/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.spreadsheet.CellParseException;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.solver.SpreadsheetCell;

public class Spreadsheets {
    public static final int SPREADSHEET_BTREE_SIZE = 100;
    public static final String CELL_TYPE_URI = "http://www.simantics.org/Spreadsheet-1.2/Cell";
    public static final String LINE_TYPE_URI = "http://www.simantics.org/Spreadsheet-1.2/Line";
    public static final String LINES_TYPE_URI = "http://www.simantics.org/Spreadsheet-1.2/Lines";

    public static boolean asBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof Variant) {
            return Spreadsheets.asBoolean(((Variant)object).getValue());
        }
        if (object instanceof String) {
            Double d = Spreadsheets.asDoubleWhereEmptyStringIsZero((String)object);
            if (d == null) {
                return false;
            }
            return d != 0.0;
        }
        return false;
    }

    public static String asString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number) {
            double dVal = ((Number)object).doubleValue();
            if (dVal == Math.floor(dVal)) {
                return "" + ((Number)object).intValue();
            }
            return object.toString();
        }
        if (object instanceof Variant) {
            Object o = ((Variant)object).getValue();
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof Number) {
                Spreadsheets.asString((Number)o);
            } else {
                return o.toString();
            }
        }
        return object.toString();
    }

    public static Double asDoubleWhereEmptyStringIsZero(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                if (((String)object).isEmpty()) {
                    return 0.0;
                }
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Variant) {
            Object o = ((Variant)object).getValue();
            return Spreadsheets.asDoubleWhereEmptyStringIsZero(o);
        }
        if (SpreadsheetCell.EMPTY == object) {
            return null;
        }
        return null;
    }

    public static double asNumber(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            block7: {
                try {
                    String str = (String)object;
                    if (!str.isEmpty()) break block7;
                    return 0.0;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0.0;
                }
            }
            return Double.parseDouble((String)object);
        }
        if (object instanceof Variant) {
            Object o = ((Variant)object).getValue();
            return Spreadsheets.asNumber(o);
        }
        if (SpreadsheetCell.EMPTY == object) {
            return 0.0;
        }
        return 0.0;
    }

    public static Number asValidNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (object instanceof Variant) {
            Object o = ((Variant)object).getValue();
            return Spreadsheets.asNumber(o);
        }
        if (SpreadsheetCell.EMPTY == object) {
            return null;
        }
        return null;
    }

    public static boolean matchCriteria(Object value, Object criteria) {
        Double dVal;
        if (value == null || criteria == null) {
            return false;
        }
        if (value instanceof Variant) {
            dVal = Spreadsheets.asDoubleWhereEmptyStringIsZero(value);
            value = dVal == null ? ((Variant)value).getValue() : dVal;
        }
        if (criteria instanceof Variant) {
            dVal = Spreadsheets.asDoubleWhereEmptyStringIsZero(criteria);
            criteria = dVal == null ? ((Variant)criteria).getValue() : dVal;
        }
        if (criteria instanceof Number && value instanceof Number) {
            Double nc = Spreadsheets.asNumber(criteria);
            Double nv = Spreadsheets.asNumber(value);
            return ((Object)nc).equals(nv);
        }
        if (criteria instanceof String) {
            Double criteriaNum;
            String criteriaStr;
            String oper;
            boolean nums = false;
            Object valueObj = null;
            if (value instanceof Number) {
                valueObj = ((Number)value).doubleValue();
                nums = true;
            } else {
                valueObj = value.toString();
            }
            String sc = criteria.toString();
            if (sc.length() >= 3) {
                block36: {
                    block35: {
                        oper = sc.substring(0, 2);
                        criteriaStr = sc.substring(2);
                        criteriaNum = null;
                        criteriaNum = Double.parseDouble(criteriaStr);
                        if (!oper.equals("<>")) break block35;
                        if (!nums) {
                            return true;
                        }
                        break block36;
                    }
                    if (nums) break block36;
                    return false;
                }
                try {
                    nums = true;
                }
                catch (NumberFormatException numberFormatException) {
                    if (oper.equals("<>")) {
                        if (nums) {
                            return true;
                        }
                    } else if (nums) {
                        return false;
                    }
                    nums = false;
                }
                if (oper.equals(">=")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) >= 0;
                    }
                    return ((Number)valueObj).doubleValue() >= criteriaNum;
                }
                if (oper.equals("<=")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) <= 0;
                    }
                    return ((Number)valueObj).doubleValue() <= criteriaNum;
                }
                if (oper.equals("<>")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) != 0;
                    }
                    return ((Number)valueObj).doubleValue() != criteriaNum.doubleValue();
                }
            }
            if (sc.length() >= 2) {
                block37: {
                    oper = sc.substring(0, 1);
                    criteriaStr = sc.substring(1);
                    criteriaNum = null;
                    criteriaNum = Double.parseDouble(criteriaStr);
                    if (nums) break block37;
                    return false;
                }
                try {
                    nums = true;
                }
                catch (NumberFormatException numberFormatException) {
                    if (nums) {
                        return false;
                    }
                    nums = false;
                }
                if (oper.equals("<")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) < 0;
                    }
                    return ((Number)valueObj).doubleValue() < criteriaNum;
                }
                if (oper.equals(">")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) > 0;
                    }
                    return ((Number)valueObj).doubleValue() > criteriaNum;
                }
                if (oper.equals("=")) {
                    if (!nums) {
                        return valueObj.toString().toLowerCase().compareTo(criteriaStr.toLowerCase()) == 0;
                    }
                    return ((Number)valueObj).doubleValue() == criteriaNum.doubleValue();
                }
            }
            return sc.equals(valueObj);
        }
        if (criteria instanceof Number) {
            return false;
        }
        throw new IllegalStateException();
    }

    public static boolean excelEquals(Object left, Object right) {
        if (left instanceof String && right instanceof String) {
            return ((String)left).toLowerCase().equals(((String)right).toLowerCase());
        }
        return left.equals(right);
    }

    public static String columnName(int column, int current, int limit, int chars) {
        if (column < limit) {
            char[] buf = new char[chars];
            column -= current;
            int i = chars - 1;
            while (i >= 0) {
                char rem = (char)(column % 26);
                column /= 26;
                buf[i] = (char)(65 + rem);
                --i;
            }
            return new String(buf);
        }
        return Spreadsheets.columnName(column, limit, 26 * (limit + 1), chars + 1);
    }

    public static String columnName(int column) {
        return Spreadsheets.columnName(column, 0, 26, 1);
    }

    public static String cellName(int row, int column) {
        String result = Spreadsheets.columnName(column);
        result = String.valueOf(result) + (row + 1);
        return result;
    }

    public static String offset(String location, int rowOffset, int columnOffset) {
        Range range = Spreadsheets.decodeCellAbsolute(location);
        String result = Spreadsheets.cellName(range.startRow + rowOffset, range.startColumn + columnOffset);
        return result;
    }

    public static Range decodeCellAbsolute(String identifier) {
        long l = Spreadsheets.decodeCellCoded(identifier);
        int row = (int)(l & 0xFFFFFFFFFFFFFFFFL) - 1;
        int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return new Range(row, row, column, column);
    }

    public static Range decodePossibleCellAbsolute(String identifier) {
        try {
            return Spreadsheets.decodeCellAbsolute(identifier);
        }
        catch (CellParseException cellParseException) {
            return null;
        }
    }

    public static long decodeCellCoded(String identifier) {
        char b;
        int row = 0;
        int column = 0;
        int position = 0;
        if (identifier.charAt(position) == '$') {
            ++position;
        }
        int length = identifier.length();
        while (position < length) {
            b = identifier.charAt(position);
            if (b < 'A' || b > 'Z') break;
            column = column * 26 + (b - 65 + 1);
            ++position;
        }
        if (position < length && identifier.charAt(position) == '$') {
            ++position;
        }
        while (position < length) {
            b = identifier.charAt(position);
            if (b >= '0' && b <= '9') {
                row = row * 10 + b - 48;
            } else {
                char b2;
                if (b != '-' || position >= length - 1) break;
                if ((b2 = identifier.charAt(++position)) == '1') {
                    row = 0;
                    ++position;
                    break;
                }
            }
            ++position;
        }
        if (position == length) {
            return (long)row + ((long)(--column) << 32);
        }
        throw new CellParseException("Cell identifier '" + identifier + "' is not a valid cell reference.");
    }

    public static Range decodeCellRelative(String identifier, int row, int column) {
        int offset = Integer.valueOf(identifier.substring(1).trim());
        if (identifier.startsWith("L") || identifier.startsWith("l")) {
            return new Range(row, row, column - offset, column - offset);
        }
        if (identifier.startsWith("R") || identifier.startsWith("r")) {
            return new Range(row, row, column + offset, column + offset);
        }
        if (identifier.startsWith("U") || identifier.startsWith("u")) {
            return new Range(row - offset, row - offset, column, column);
        }
        if (identifier.startsWith("D") || identifier.startsWith("d")) {
            return new Range(row + offset, row + offset, column, column);
        }
        throw new CellParseException("Relative cell syntax must begin with L|R|U|D.");
    }

    public static Range decodeCell(String identifier, int row, int column) {
        if (identifier.startsWith("_")) {
            return Spreadsheets.decodeCellRelative(identifier.substring(1), row, column);
        }
        return Spreadsheets.decodeCellAbsolute(identifier);
    }

    public static Range decodeReference(String identifier, int row, int column) {
        if (!identifier.startsWith("&")) {
            throw new CellParseException("A reference cell was expected.");
        }
        return Spreadsheets.decodeRange(identifier.substring(1), row, column);
    }

    public static List<Range> decodeRanges(String ranges) {
        String[] splitted = ranges.split(",");
        ArrayList<Range> result = new ArrayList<Range>();
        String[] stringArray = splitted;
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            result.add(Spreadsheets.decodeRange(split));
            ++n2;
        }
        return result;
    }

    public static Object extract(Object object, int row, int column) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() <= row) {
                return null;
            }
            Object item = list.get(row);
            if (item instanceof Tuple) {
                Tuple tuple = (Tuple)item;
                if (tuple.length() <= column) {
                    return null;
                }
                return tuple.get(column);
            }
        }
        return null;
    }

    public static int startRow(List<Range> ranges) {
        int s = -1;
        for (Range r : ranges) {
            if (r.startRow >= s && s != -1) continue;
            s = r.startRow;
        }
        return s;
    }

    public static int startColumn(List<Range> ranges) {
        int s = -1;
        for (Range r : ranges) {
            if (r.startColumn >= s && s != -1) continue;
            s = r.startColumn;
        }
        return s;
    }

    public static int amountOfRows(Range r) {
        int endRow = -2;
        int startRow = -2;
        if (r.isFullRows()) {
            return Integer.MAX_VALUE;
        }
        if (endRow == -2 && startRow == -2) {
            endRow = r.endRow;
            startRow = r.startRow;
        }
        if (r.startRow < startRow) {
            startRow = r.startRow;
        }
        if (r.endRow > endRow) {
            endRow = r.endRow;
        }
        return endRow - startRow + 1;
    }

    public static int amountOfColumns(Range r) {
        int endColumn = -2;
        int startColumn = -2;
        if (r.isFullColumns()) {
            return Integer.MAX_VALUE;
        }
        if (endColumn == -2 && startColumn == -2) {
            endColumn = r.endColumn;
            startColumn = r.startColumn;
        }
        if (r.startColumn < startColumn) {
            startColumn = r.startColumn;
        }
        if (r.endColumn > endColumn) {
            endColumn = r.endColumn;
        }
        return endColumn - startColumn + 1;
    }

    public static Range decodeRange(String rangeOrCell) {
        if (rangeOrCell.isEmpty()) {
            return Spreadsheets.fullRange();
        }
        return Spreadsheets.decodeRange(rangeOrCell, 0, 0);
    }

    public static Range fullRange() {
        return new Range(0, -1, 0, -1);
    }

    public static Range decodeRange(String rangeOrCell, int row, int column) {
        String[] parts = rangeOrCell.split(":");
        if (parts.length == 1) {
            return Spreadsheets.decodeCell(rangeOrCell, row, column);
        }
        if (parts.length == 2) {
            Range from = Spreadsheets.decodeCell(parts[0].trim(), row, column);
            Range to = Spreadsheets.decodeCell(parts[1].trim(), row, column);
            return Range.combine(from, to);
        }
        throw new CellParseException("The reference cell syntax was invalid. At most 1 occurrence of ':' is expected.");
    }
}

