/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet;

import org.simantics.spreadsheet.Spreadsheets;

public class Range {
    public static final int MAXROWSPEC = Integer.MAX_VALUE;
    public static final int MAXCOLUMNSPEC = Integer.MAX_VALUE;
    public int startRow;
    public int endRow;
    public int startColumn;
    public int endColumn;

    public Range(int startRow, int endRow, int startColumn, int endColumn) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        if (startRow == -1) {
            this.startRow = Integer.MAX_VALUE;
        }
        if (endRow == -1) {
            this.endRow = Integer.MAX_VALUE;
        }
        if (startColumn == -1) {
            this.startColumn = Integer.MAX_VALUE;
        }
        if (endColumn == -1) {
            this.endColumn = Integer.MAX_VALUE;
        }
    }

    public Range(Range copy) {
        this.startRow = copy.startRow;
        this.endRow = copy.endRow;
        this.startColumn = copy.startColumn;
        this.endColumn = copy.endColumn;
    }

    public static Range parse(String identifier) {
        return Spreadsheets.decodeCellAbsolute(identifier);
    }

    public static Range combine(Range from, Range to) {
        return new Range(from.startRow, to.endRow, from.startColumn, to.endColumn);
    }

    public boolean isFull() {
        return this.endRow == Integer.MAX_VALUE && this.endColumn == Integer.MAX_VALUE;
    }

    public boolean isFullRows() {
        return this.endRow == Integer.MAX_VALUE;
    }

    public boolean isFullColumns() {
        return this.endColumn == Integer.MAX_VALUE;
    }

    public int size() {
        return (this.endRow - this.startRow + 1) * (this.endColumn - this.startColumn + 1);
    }

    public int width() {
        return this.endColumn - this.startColumn + 1;
    }

    public int height() {
        return this.endRow - this.startRow + 1;
    }

    public boolean contains(Range r) {
        if (this.endRow >= 0) {
            if (r.endRow > this.endRow) {
                return false;
            }
            if (r.startRow < this.startRow) {
                return false;
            }
        }
        if (this.endColumn >= 0) {
            if (r.startColumn < this.startColumn) {
                return false;
            }
            if (r.endColumn > this.endColumn) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Range[(" + this.startRow + "," + this.startColumn + ")-(" + this.endRow + "," + this.endColumn + ")]";
    }
}

