/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.utils.NodeUtil;

public final class NodeMapper {
    Map<INode, String> nodes = new HashMap<INode, String>();
    Map<INode, String> managedNodes = new HashMap<INode, String>();

    public NodeMapper() {
    }

    public NodeMapper(INode node) {
        this.add0(node);
    }

    public void clear() {
        for (Map.Entry<INode, String> entry : this.managedNodes.entrySet()) {
            ILookupService lu = NodeUtil.tryGetLookupService(entry.getKey());
            if (lu == null) continue;
            String mappedId = lu.lookupId(entry.getKey());
            if (!entry.getValue().equals(mappedId)) continue;
            lu.unmap(entry.getKey());
        }
        this.managedNodes.clear();
        this.nodes.clear();
    }

    public NodeMapper(Collection<? extends INode> nodes) {
        this.addAll(nodes);
    }

    public String add(INode node) {
        return this.add0(node);
    }

    public void addAll(Collection<? extends INode> nodes) {
        for (INode iNode : nodes) {
            this.add0(iNode);
        }
    }

    public String remove(INode node) {
        return this.remove0(node);
    }

    public String getId(INode node) {
        return this.nodes.get(node);
    }

    private String add0(INode node) {
        String id = this.nodes.get(node);
        if (id != null) {
            return id;
        }
        id = NodeUtil.lookupId(node);
        if (id != null) {
            this.nodes.put(node, id);
            return id;
        }
        id = UUID.randomUUID().toString();
        NodeUtil.map(node, id);
        this.nodes.put(node, id);
        this.managedNodes.put(node, id);
        return id;
    }

    private String remove0(INode node) {
        String mappedId;
        ILookupService lu;
        String id = null;
        id = this.nodes.remove(node);
        if (id != null && this.managedNodes.remove(node) != null && (lu = NodeUtil.tryGetLookupService(node)) != null && id.equals(mappedId = lu.lookupId(node))) {
            lu.unmap(node);
        }
        return id;
    }
}

