/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.DummyComponent;
import org.simantics.scenegraph.utils.NodeUtil;

public class BooleanToggleValueNode
extends G2DNode
implements ActionListener {
    private static final long serialVersionUID = 3255791584573492072L;
    protected static final BasicStroke STROKE = new BasicStroke(1.0f);
    protected static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
    protected Boolean value = null;
    protected transient boolean mouseOver = false;
    protected transient ActionListener actionListener = null;

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @INode.SyncField(value={"value"})
    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    public void render(Graphics2D g) {
        Color borderColor = new Color(160, 10, 10);
        Color fillColor = new Color(210, 10, 10);
        boolean in = false;
        if (this.value != null && this.value.booleanValue()) {
            borderColor = new Color(10, 160, 10);
            fillColor = new Color(10, 210, 10);
            in = true;
        }
        if (this.mouseOver) {
            borderColor = borderColor.darker();
        }
        AffineTransform ot = g.getTransform();
        g.transform(this.transform);
        g.setColor(fillColor);
        g.fill(BOUNDS);
        g.setStroke(STROKE);
        g.setColor(in ? borderColor.darker().darker() : borderColor);
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getMinX(), BOUNDS.getMaxY()));
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getMaxX(), BOUNDS.getMinY()));
        g.setColor(in ? borderColor : borderColor.darker().darker());
        g.draw(new Line2D.Double(BOUNDS.getMaxX(), BOUNDS.getMinY(), BOUNDS.getMaxX(), BOUNDS.getMaxY()));
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMaxY(), BOUNDS.getMaxX(), BOUNDS.getMaxY()));
        g.setTransform(ot);
    }

    public static Shape getOutline() {
        return BOUNDS;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return BOUNDS;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    @INode.ServerSide
    public void actionPerformed(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    @Override
    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        Point2D pt = NodeUtil.worldToLocal(this, e.controlPosition, new Point2D.Double());
        if (BOUNDS.contains(pt)) {
            this.setValue(this.value == null || this.value == false);
            this.actionPerformed(new ActionEvent(new DummyComponent(), 1001, "" + this.value));
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        Point2D pt = NodeUtil.worldToLocal(this, e.controlPosition, new Point2D.Double());
        boolean tmp = this.mouseOver;
        this.mouseOver = BOUNDS.contains(pt);
        if (tmp != this.mouseOver) {
            this.repaint();
        }
        return false;
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseMovedMask | EventTypes.MouseClickMask;
    }
}

