/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing.internal;

import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.db.indexing.exception.IndexingException;

public abstract class IndexingJob
extends Job {
    private static final String DATABASE_JOB_FAMILY = "org.simantics.db.inDatabaseJob";

    public IndexingJob(String name) {
        super(name);
    }

    public boolean belongsTo(Object family) {
        return DATABASE_JOB_FAMILY.equals(family);
    }

    public static void jobifyIfPossible(IProgressMonitor monitor, String jobName, final DbConsumer<IProgressMonitor> consumer) throws DatabaseException {
        if (Job.getJobManager().isSuspended() || Job.getJobManager().currentJob() != null) {
            consumer.accept((Object)monitor);
            return;
        }
        final Semaphore barrier = new Semaphore(0);
        final Throwable[] err = new Throwable[1];
        IndexingJob job = new IndexingJob(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        consumer.accept((Object)monitor);
                    }
                    catch (Throwable t) {
                        err[0] = t;
                        monitor.done();
                        barrier.release();
                    }
                }
                finally {
                    monitor.done();
                    barrier.release();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            barrier.acquire();
            if (err[0] != null) {
                if (err[0] instanceof IndexingException) {
                    throw (DatabaseException)err[0];
                }
                throw new IndexingException(err[0]);
            }
        }
        catch (InterruptedException e) {
            throw new IndexingException(e);
        }
    }
}

