/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.JScrollPaneSG;
import org.simantics.spreadsheet.Adaptable;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.SheetCommands;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.common.cell.Parsers;
import org.simantics.spreadsheet.common.cell.StringCellParser;
import org.simantics.spreadsheet.event.model.RemoveCellHandler;
import org.simantics.spreadsheet.ui.CellValue;
import org.simantics.spreadsheet.ui.ClientModelImpl;
import org.simantics.spreadsheet.ui.ClientTableModel;
import org.simantics.spreadsheet.ui.ColumnHeaderRenderer;
import org.simantics.spreadsheet.ui.DefaultLookup;
import org.simantics.spreadsheet.ui.ExcelAdapter;
import org.simantics.spreadsheet.ui.ExpressionTextListener;
import org.simantics.spreadsheet.ui.JFontChooser;
import org.simantics.spreadsheet.ui.RowHeaderRenderer;
import org.simantics.spreadsheet.ui.SelectionListener;
import org.simantics.spreadsheet.ui.SpreadsheetTable;
import org.simantics.spreadsheet.ui.SpreadsheetTableUI;
import org.simantics.spreadsheet.ui.TableDropTargetListener;
import org.simantics.spreadsheet.ui.TableRowResizer;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.ui.awt.WrapLayout;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.simantics.utils.ui.jface.ActiveSelectionProvider;

public class SpreadsheetModel {
    private static final String OPERATIONMODE = "Operation Mode";
    private static final String EDITMODE = "Edit Mode";
    private final Adaptable serverInterface;
    private final ClientModel clientModel;
    private final ActiveSelectionProvider selectionProvider;
    protected Clipboard system;
    protected StringCellParser[] parsers = new StringCellParser[]{Parsers.COMMAND_PARSER, Parsers.EXPRESSION_PARSER, Parsers.TEXT_PARSER};
    private JTextField expression;
    private JButton foreground;
    private JButton background;
    private JButton font;
    private JButton align_left;
    private JButton align_hcenter;
    private JButton align_right;
    private JButton align_top;
    private JButton align_vcenter;
    private JButton align_bottom;
    private JComboBox borders;
    public JComboBox inputSource;
    public JComboBox sheets;
    private JButton lock;
    private JButton unlock;
    private JButton merge;
    private JButton unmerge;
    private ExpressionTextListener etl;
    private SpreadsheetTable table;
    private ExcelAdapter excel;
    private boolean columnMarginsDirty = false;
    private ItemListener itemListener = null;
    private ItemListener sheetsListener = null;
    private ItemListener initialConditionsListener = null;
    private JComboBox initialConditions;
    private JButton saveIc;
    private JButton context;
    private JToggleButton operationMode;
    private JCheckBox iterationEnabled;
    private JTextField iterationLimit;

    public SpreadsheetModel(Adaptable serverInterface, ActiveSelectionProvider selectionProvider) {
        this.serverInterface = serverInterface;
        this.clientModel = new ClientModelImpl();
        this.selectionProvider = selectionProvider;
    }

    public ClientModel getClientModel() {
        return this.clientModel;
    }

    public SpreadsheetTable getTable() {
        return this.table;
    }

    public JComponent createComponent(INode node) {
        Properties props = (Properties)this.serverInterface.getAdapter(Properties.class);
        boolean addExpressionField = props == null || "true".equalsIgnoreCase(props.getProperty("sheet.expression.visible", "true"));
        JPanel panel = new JPanel(new BorderLayout());
        final DefaultListModel lm = new DefaultListModel(){
            private static final long serialVersionUID = 5246691801867533053L;

            @Override
            public Object getElementAt(int index) {
                Object result = super.getElementAt(index);
                if (result instanceof String) {
                    return result;
                }
                return "" + (index + 1);
            }
        };
        if (addExpressionField) {
            BufferedImage img;
            BufferedImage img2;
            this.foreground = new JButton();
            this.foreground.setToolTipText("Assign foreground color to selection");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/paintbrush.png"));
                this.foreground.setIcon(new ImageIcon(img2));
            }
            catch (IOException iOException) {}
            this.foreground.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.awt.Color c = JColorChooser.showDialog(SpreadsheetModel.this.foreground, "asd", Colors.awt((Color)Colors.rgb((double)0.0, (double)0.0, (double)0.0)));
                    if (c == null) {
                        return;
                    }
                    RGB.Integer color = Colors.integerRGB((java.awt.Color)c);
                    SpreadsheetModel.this.editSelection("foreground", color, RGB.Integer.BINDING);
                }
            });
            this.background = new JButton();
            this.background.setToolTipText("Assign background color to selection");
            try {
                img2 = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/paintcan.png"));
                this.background.setIcon(new ImageIcon(img2));
            }
            catch (IOException iOException) {}
            this.background.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    java.awt.Color c = JColorChooser.showDialog(SpreadsheetModel.this.background, "asd", Colors.awt((Color)Colors.rgb((double)0.0, (double)0.0, (double)0.0)));
                    if (c == null) {
                        return;
                    }
                    RGB.Integer color = Colors.integerRGB((java.awt.Color)c);
                    SpreadsheetModel.this.editSelection("background", color, RGB.Integer.BINDING);
                }
            });
            String[] availableInitialConditions = (String[])this.clientModel.getPossiblePropertyAt("States", "available");
            String currentInitialCondition = (String)this.clientModel.getPossiblePropertyAt("States", "current");
            this.initialConditions = new JComboBox();
            String[] stringArray = availableInitialConditions;
            int n = availableInitialConditions.length;
            int n2 = 0;
            while (n2 < n) {
                String sheet = stringArray[n2];
                this.initialConditions.addItem(sheet);
                ++n2;
            }
            this.initialConditions.setSelectedItem(currentInitialCondition);
            this.initialConditionsListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor != null && arg0.getStateChange() == 1) {
                        editor.edit(null, "States", "current", arg0.getItem(), null, null);
                    }
                }
            };
            this.initialConditions.addItemListener(this.initialConditionsListener);
            this.saveIc = new JButton();
            this.saveIc.setText("Save IC");
            this.saveIc.setToolTipText("Save current Initial Condition");
            this.saveIc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SheetCommands commands = (SheetCommands)SpreadsheetModel.this.serverInterface.getAdapter(SheetCommands.class);
                    commands.saveState();
                }
            });
            this.font = new JButton();
            this.font.setToolTipText("Assign font to selection");
            this.font.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFontChooser fontChooser = new JFontChooser();
                    int result = fontChooser.showDialog(SpreadsheetModel.this.font);
                    if (result == 0) {
                        java.awt.Font font = fontChooser.getSelectedFont();
                        System.out.println("Selected Font : " + font);
                        Font f = Fonts.fromAWT((java.awt.Font)font);
                        SpreadsheetModel.this.editSelection("font", f, Font.BINDING);
                    }
                }
            });
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/font.png"));
                this.font.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_left = new JButton();
            this.align_left.setToolTipText("Align selection to left");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_left.png"));
                this.align_left.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_left.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(0, null);
                }
            });
            this.align_hcenter = new JButton();
            this.align_hcenter.setToolTipText("Align selection horizontally to center");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_center.png"));
                this.align_hcenter.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_hcenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(1, null);
                }
            });
            this.align_right = new JButton();
            this.align_right.setToolTipText("Align selection to right");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_right.png"));
                this.align_right.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_right.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(2, null);
                }
            });
            this.align_top = new JButton();
            this.align_top.setToolTipText("Align selection to top");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_top.png"));
                this.align_top.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_top.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(null, 0);
                }
            });
            this.align_vcenter = new JButton();
            this.align_vcenter.setToolTipText("Align selection vertically to center");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_middle.png"));
                this.align_vcenter.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_vcenter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(null, 1);
                }
            });
            this.align_bottom = new JButton();
            this.align_bottom.setToolTipText("Align selection to bottom");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/shape_align_bottom.png"));
                this.align_bottom.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.align_bottom.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelectionAlignment(null, 2);
                }
            });
            this.borders = new JComboBox();
            this.borders.addItem("No borders");
            this.borders.addItem("Bottom border");
            this.borders.addItem("Top border");
            this.borders.addItem("Left border");
            this.borders.addItem("Right border");
            this.borders.addActionListener(new ActionListener(){
                Map<String, Integer> work = new HashMap<String, Integer>();

                int getCurrent(String location, int row, int column) {
                    CellValue value = (CellValue)SpreadsheetModel.this.table.getValueAt(row, column);
                    int border = value != null ? value.border : 0;
                    this.work.put(location, border);
                    return border;
                }

                void setCurrent(String location, int border) {
                    this.work.put(location, border);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.work.clear();
                    int index = SpreadsheetModel.this.borders.getSelectedIndex();
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    Object object = selectedColumns;
                    int n = selectedColumns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int col = object[n2];
                        int[] nArray = selectedRows;
                        int n3 = selectedRows.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String up;
                            String left;
                            int row = nArray[n4];
                            String location = Spreadsheets.cellName((int)row, (int)col);
                            if (index == 0) {
                                if (col > 0) {
                                    left = Spreadsheets.cellName((int)row, (int)(col - 1));
                                    this.setCurrent(left, this.getCurrent(left, row, col - 1) & 2);
                                }
                                if (row > 0) {
                                    up = Spreadsheets.cellName((int)(row - 1), (int)col);
                                    this.setCurrent(up, this.getCurrent(up, row - 1, col) & 1);
                                }
                                this.setCurrent(location, 0);
                            } else if (index == 1) {
                                this.setCurrent(location, this.getCurrent(location, row, col) | 2);
                            } else if (index == 2) {
                                if (row > 0) {
                                    up = Spreadsheets.cellName((int)(row - 1), (int)col);
                                    this.setCurrent(up, this.getCurrent(up, row - 1, col) | 2);
                                }
                            } else if (index == 3) {
                                if (col > 0) {
                                    left = Spreadsheets.cellName((int)row, (int)(col - 1));
                                    this.setCurrent(left, this.getCurrent(left, row, col - 1) | 1);
                                }
                            } else if (index == 4) {
                                this.setCurrent(location, this.getCurrent(location, row, col) | 1);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    OperationMode mode = (OperationMode)SpreadsheetModel.this.clientModel.getPropertyAt("Mode", "current");
                    Transaction transaction = editor.startTransaction(mode);
                    object = this.work.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        String location = (String)entry.getKey();
                        Integer border = (Integer)entry.getValue();
                        editor.edit(transaction, location, "border", (Object)border, (Binding)Bindings.INTEGER, null);
                    }
                    transaction.commit();
                }
            });
            this.lock = new JButton();
            this.lock.setToolTipText("Lock selection");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/lock.png"));
                this.lock.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.lock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelection("locked", true, (Binding)Bindings.BOOLEAN);
                }
            });
            this.unlock = new JButton();
            this.unlock.setToolTipText("Unlock selection");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/lock_open.png"));
                this.unlock.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.unlock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadsheetModel.this.editSelection("locked", false, (Binding)Bindings.BOOLEAN);
                }
            });
            this.merge = new JButton();
            this.merge.setToolTipText("Merge cells");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/link.png"));
                this.merge.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.merge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedColumns = SpreadsheetModel.this.table.getSelectedColumns();
                    int[] selectedRows = SpreadsheetModel.this.table.getSelectedRows();
                    if (SpreadsheetModel.this.isRectangularSelection(SpreadsheetModel.this.table)) {
                        CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                        if (editor == null) {
                            return;
                        }
                        OperationMode mode = (OperationMode)SpreadsheetModel.this.clientModel.getPropertyAt("Mode", "current");
                        Transaction transaction = editor.startTransaction(mode);
                        Rectangle selection = new Rectangle(selectedColumns[0], selectedRows[0], selectedColumns.length, selectedRows.length);
                        List spans = SpreadsheetModel.this.clientModel.getSpans();
                        boolean found = true;
                        while (found) {
                            found = false;
                            Iterator iter = spans.iterator();
                            while (iter.hasNext()) {
                                Rectangle span = (Rectangle)iter.next();
                                if (!selection.intersects(span)) continue;
                                selection = selection.union(span);
                                found = true;
                                String location = Spreadsheets.cellName((int)span.y, (int)span.x);
                                editor.edit(transaction, location, "rowSpan", (Object)1, (Binding)Bindings.INTEGER, null);
                                editor.edit(transaction, location, "columnSpan", (Object)1, (Binding)Bindings.INTEGER, null);
                                iter.remove();
                            }
                        }
                        String location = Spreadsheets.cellName((int)selection.y, (int)selection.x);
                        if (selection.height > 1) {
                            editor.edit(transaction, location, "rowSpan", (Object)selection.height, (Binding)Bindings.INTEGER, null);
                        }
                        if (selection.width > 1) {
                            editor.edit(transaction, location, "columnSpan", (Object)selection.width, (Binding)Bindings.INTEGER, null);
                        }
                        transaction.commit();
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ShowMessage.showWarning((String)"Merging cells failed", (String)"Selected range is not rectangular.");
                            }
                        });
                    }
                }
            });
            this.unmerge = new JButton();
            this.unmerge.setToolTipText("Unmerge cells");
            try {
                img = ImageIO.read(Platform.getBundle((String)"com.famfamfam.silk").getResource("icons/link_break.png"));
                this.unmerge.setIcon(new ImageIcon(img));
            }
            catch (IOException iOException) {}
            this.unmerge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor == null) {
                        return;
                    }
                    OperationMode mode = (OperationMode)SpreadsheetModel.this.clientModel.getPropertyAt("Mode", "current");
                    Transaction transaction = editor.startTransaction(mode);
                    SpreadsheetModel.this.editSelection(editor, transaction, "rowSpan", 1, (Binding)Bindings.INTEGER);
                    SpreadsheetModel.this.editSelection(editor, transaction, "columnSpan", 1, (Binding)Bindings.INTEGER);
                    transaction.commit();
                }
            });
            String[] availableSources = (String[])this.clientModel.getPossiblePropertyAt("Sources", "available");
            String[] availableSheets = (String[])this.clientModel.getPossiblePropertyAt("Sheets", "available");
            String currentSheet = (String)this.clientModel.getPossiblePropertyAt("Sheets", "current");
            String cfr_ignored_0 = (String)this.clientModel.getPossiblePropertyAt("Sources", "current");
            this.inputSource = new JComboBox();
            String[] stringArray2 = availableSources;
            int n3 = availableSources.length;
            int n4 = 0;
            while (n4 < n3) {
                String source = stringArray2[n4];
                this.inputSource.addItem(source);
                ++n4;
            }
            this.sheets = new JComboBox();
            stringArray2 = availableSheets;
            n3 = availableSheets.length;
            n4 = 0;
            while (n4 < n3) {
                String sheet = stringArray2[n4];
                this.sheets.addItem(sheet);
                ++n4;
            }
            this.sheets.setSelectedItem(currentSheet);
            this.sheetsListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor != null && arg0.getStateChange() == 1) {
                        editor.edit(null, "Sheets", "current", arg0.getItem(), null, null);
                        HashSet<String> targets = new HashSet<String>();
                        targets.add("Mode");
                        SpreadsheetModel.this.resetSelections(editor, targets);
                    }
                }
            };
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor != null && arg0.getStateChange() == 1) {
                        editor.edit(null, "Sources", "current", arg0.getItem(), null, null);
                    }
                }
            };
            this.inputSource.addItemListener(this.itemListener);
            new DropTarget(this.inputSource, 3, new DropTargetListener(){

                @Override
                public void dropActionChanged(DropTargetDragEvent arg0) {
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    try {
                        Transferable transferable = dtde.getTransferable();
                        if (transferable.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
                            dtde.acceptDrop(2);
                            transferable.getTransferData(LocalObjectTransferable.FLAVOR);
                            Object obj = LocalObjectTransfer.getTransfer().getObject();
                            CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                            if (editor != null) {
                                editor.edit(null, "Sources", "current", obj, null, null);
                            }
                            dtde.getDropTargetContext().dropComplete(true);
                        } else {
                            dtde.rejectDrop();
                        }
                    }
                    catch (IOException exception) {
                        exception.printStackTrace();
                        dtde.rejectDrop();
                    }
                    catch (UnsupportedFlavorException ufException) {
                        ufException.printStackTrace();
                        dtde.rejectDrop();
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent arg0) {
                }

                @Override
                public void dragExit(DropTargetEvent arg0) {
                }

                @Override
                public void dragEnter(DropTargetDragEvent arg0) {
                }
            });
            this.expression = new JTextField();
            this.etl = new ExpressionTextListener(this.expression, (CellEditor)this.serverInterface.getAdapter(CellEditor.class));
            this.expression.addFocusListener(this.etl);
            this.expression.addKeyListener(this.etl);
            this.expression.setPreferredSize(new Dimension(600, 32));
            this.sheets.addItemListener(this.sheetsListener);
            this.context = new JButton("Change context");
            this.context.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CellEditor editor;
                    Frame frame = (Frame)SwingUtilities.getRoot(SpreadsheetModel.this.context);
                    String result = JOptionPane.showInputDialog(frame, (Object)"Context URI");
                    if (result != null && !result.isEmpty() && (editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class)) != null) {
                        editor.edit(null, "Context", "current", (Object)result, null, null);
                    }
                }
            });
            OperationMode currentMode = (OperationMode)this.clientModel.getPropertyAt("Mode", "current");
            String text = currentMode.equals((Object)OperationMode.OPERATION) ? OPERATIONMODE : EDITMODE;
            this.operationMode = new JToggleButton(text);
            this.operationMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newText;
                    OperationMode newMode;
                    OperationMode currentMode = (OperationMode)SpreadsheetModel.this.clientModel.getPropertyAt("Mode", "current");
                    if (currentMode.equals((Object)OperationMode.OPERATION)) {
                        System.err.println("Current mode is operation");
                        newMode = OperationMode.EDIT_MODE;
                        newText = SpreadsheetModel.EDITMODE;
                    } else {
                        System.err.println("Current mode is read-only");
                        newMode = OperationMode.OPERATION;
                        newText = SpreadsheetModel.OPERATIONMODE;
                    }
                    System.err.println("Setting new text " + newText + " to replace old " + SpreadsheetModel.this.operationMode.getText());
                    SpreadsheetModel.this.operationMode.setText(newText);
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor != null) {
                        editor.edit(null, "Mode", "current", (Object)newMode, null, null);
                    }
                }
            });
            this.iterationEnabled = new JCheckBox("Iteration Enabled");
            this.iterationEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("state is " + SpreadsheetModel.this.iterationEnabled.isSelected());
                    CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                    if (editor != null) {
                        editor.edit(null, "iterationEnabled", "iterationEnabled", (Object)SpreadsheetModel.this.iterationEnabled.isSelected(), null, null);
                    }
                }
            });
            this.iterationLimit = new JTextField("100");
            this.iterationLimit.setEnabled(false);
            this.iterationLimit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
        }
        java.awt.Font font = new java.awt.Font("Courier", 0, 14);
        UIManager.put("SpreadsheetTableUI", SpreadsheetTableUI.class.getCanonicalName());
        final JList rowHeader = new JList(lm);
        this.table = new SpreadsheetTable(node, (CellEditor)this.serverInterface.getAdapter(CellEditor.class), this.clientModel, lm, rowHeader){
            private static final long serialVersionUID = 4553572254034185984L;

            protected void mouseDragFinished() {
                CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                if (editor == null) {
                    return;
                }
                TableColumn column = SpreadsheetModel.this.table.getTableHeader().getResizingColumn();
                if (column == null) {
                    return;
                }
                int[] current = SpreadsheetModel.this.clientModel.getColumnWidths();
                if (column.getModelIndex() >= current.length) {
                    current = Arrays.copyOf(current, column.getModelIndex() + 1);
                }
                current[column.getModelIndex()] = column.getWidth();
                editor.edit(null, "Headers", "columnWidths", (Object)current, (Binding)Bindings.INT_ARRAY, null);
            }
        };
        ((ClientTableModel)this.table.getModel()).setModel(this);
        InputMap im = this.table.getInputMap(1);
        AbstractAction deleteAction = new AbstractAction(){
            private static final long serialVersionUID = 428343700053346645L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println("deleteaction");
                RemoveCellHandler cfr_ignored_0 = (RemoveCellHandler)SpreadsheetModel.this.serverInterface.getAdapter(RemoveCellHandler.class);
                int[] rowSelection = SpreadsheetModel.this.table.getSelectedRows();
                int[] columnSelection = SpreadsheetModel.this.table.getSelectedColumns();
                int i = 0;
                while (i < columnSelection.length) {
                    int j = 0;
                    while (j < rowSelection.length) {
                        int row = rowSelection[j];
                        int column = columnSelection[i];
                        System.out.println("deleteaction " + row + " " + column);
                        SpreadsheetModel.this.table.getValueAt(row, column);
                        ++j;
                    }
                    ++i;
                }
            }
        };
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0);
        im.put(KeyStroke.getKeyStroke(127, 0), delete);
        this.table.getActionMap().put(im.get(KeyStroke.getKeyStroke(127, 0)), deleteAction);
        this.table.setFont(font);
        new DropTarget((Component)((Object)this.table), new TableDropTargetListener((JTable)((Object)this.table), this.serverInterface, this.clientModel));
        if (this.serverInterface != null) {
            this.excel = new ExcelAdapter((JTable)((Object)this.table), this.clientModel, this.serverInterface, this.parsers);
        }
        this.table.setAutoResizeMode(0);
        this.table.setColumnSelectionAllowed(true);
        rowHeader.setFixedCellWidth(40);
        rowHeader.setCellRenderer(new RowHeaderRenderer((JTable)((Object)this.table)));
        rowHeader.setBackground(DefaultLookup.GRAY);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int tableRows;
                int currentRows = rowHeader.getModel().getSize();
                if (currentRows != (tableRows = SpreadsheetModel.this.table.getModel().getRowCount())) {
                    lm.setSize(tableRows);
                }
            }
        });
        JScrollPaneSG scroll = new JScrollPaneSG((Component)((Object)this.table), node);
        scroll.setRowHeaderView(rowHeader);
        this.table.getParent().setBackground(DefaultLookup.GRAY);
        this.table.getTableHeader().setBackground(DefaultLookup.GRAY);
        rowHeader.getParent().setBackground(DefaultLookup.GRAY);
        scroll.getViewport().setBackground(DefaultLookup.GRAY);
        this.table.getTableHeader().setDefaultRenderer(new ColumnHeaderRenderer());
        scroll.setBackground(DefaultLookup.GRAY);
        if (this.selectionProvider != null) {
            SelectionListener listener = new SelectionListener((JTable)((Object)this.table), this.expression, this.etl, this.selectionProvider, this.serverInterface, this.clientModel);
            this.table.getSelectionModel().addListSelectionListener(listener);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
        }
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                SpreadsheetModel.this.columnMarginsDirty = true;
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        });
        new TableRowResizer((JTable)((Object)this.table)){

            @Override
            public void onResize(int row, int height) {
                if (row < 0) {
                    return;
                }
                CellEditor editor = (CellEditor)SpreadsheetModel.this.serverInterface.getAdapter(CellEditor.class);
                if (editor == null) {
                    return;
                }
                int[] current = SpreadsheetModel.this.clientModel.getRowHeights();
                if (row >= current.length) {
                    current = Arrays.copyOf(current, row + 1);
                }
                current[row] = height;
                editor.edit(null, "Headers", "rowHeights", (Object)current, (Binding)Bindings.INT_ARRAY, null);
                rowHeader.setCellRenderer(new RowHeaderRenderer((JTable)((Object)SpreadsheetModel.this.table)));
            }
        };
        if (addExpressionField) {
            JPanel tools = new JPanel((LayoutManager)new WrapLayout(3, 0, 0));
            panel.add((Component)tools, "First");
            tools.add(this.font);
            tools.add(this.foreground);
            tools.add(this.background);
            tools.add(this.align_left);
            tools.add(this.align_hcenter);
            tools.add(this.align_right);
            tools.add(this.align_top);
            tools.add(this.align_vcenter);
            tools.add(this.align_bottom);
            tools.add(this.borders);
            tools.add(this.lock);
            tools.add(this.unlock);
            tools.add(this.merge);
            tools.add(this.unmerge);
            tools.add(this.inputSource);
            tools.add(this.sheets);
            tools.add(this.initialConditions);
            tools.add(this.saveIc);
            tools.add(this.context);
            tools.add(this.operationMode);
            tools.add(this.iterationEnabled);
            tools.add(this.iterationLimit);
            tools.add(this.expression);
        }
        panel.add((Component)scroll, "Center");
        return panel;
    }

    private void resetSelections(CellEditor editor, HashSet<String> targets) {
        if (targets.contains("Mode")) {
            editor.edit(null, "Mode", "current", (Object)OperationMode.OPERATION, null, null);
            this.operationMode.setText(OPERATIONMODE);
        }
    }

    private boolean isRectangularSelection(SpreadsheetTable table) {
        int[] selectedColumns = table.getSelectedColumns();
        int[] selectedRows = table.getSelectedRows();
        if (selectedColumns.length == 0 || selectedRows.length == 0) {
            return false;
        }
        int row = 0;
        while (row < selectedRows.length - 1) {
            if (selectedRows[row + 1] != selectedRows[row] + 1) {
                return false;
            }
            ++row;
        }
        int column = 0;
        while (column < selectedColumns.length - 1) {
            if (selectedColumns[column + 1] != selectedColumns[column] + 1) {
                return false;
            }
            ++column;
        }
        return true;
    }

    private void editSelection(String property, Object value, Binding binding) {
        CellEditor editor = (CellEditor)this.serverInterface.getAdapter(CellEditor.class);
        if (editor == null) {
            return;
        }
        this.editSelection(editor, null, property, value, binding);
    }

    private void editSelection(CellEditor editor, Transaction transaction, String property, Object value, Binding binding) {
        int[] nArray = this.table.getSelectedColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int col = nArray[n2];
            int[] nArray2 = this.table.getSelectedRows();
            int n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                int row = nArray2[n4];
                String location = Spreadsheets.cellName((int)row, (int)col);
                editor.edit(transaction, location, property, value, binding, null);
                ++n4;
            }
            ++n2;
        }
    }

    private void editSelectionAlignment(Integer horizontal, Integer vertical) {
        int[] selectedColumns = this.table.getSelectedColumns();
        int[] selectedRows = this.table.getSelectedRows();
        CellEditor editor = (CellEditor)this.serverInterface.getAdapter(CellEditor.class);
        if (editor == null) {
            return;
        }
        int[] nArray = selectedColumns;
        int n = selectedColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int col = nArray[n2];
            int[] nArray2 = selectedRows;
            int n3 = selectedRows.length;
            int n4 = 0;
            while (n4 < n3) {
                int align;
                int row = nArray2[n4];
                String location = Spreadsheets.cellName((int)row, (int)col);
                CellValue value = (CellValue)this.table.getValueAt(row, col);
                int n5 = align = value != null ? value.align : 0;
                if (horizontal != null) {
                    align = (align & 0xC) + horizontal;
                }
                if (vertical != null) {
                    align = (align & 3) + (vertical << 2);
                }
                editor.edit(null, location, "align", (Object)align, (Binding)Bindings.INTEGER, null);
                ++n4;
            }
            ++n2;
        }
    }

    public ClientModel getClientInterface() {
        return this.clientModel;
    }

    public void setSources() {
        if (this.inputSource == null) {
            return;
        }
        String[] available = (String[])this.getClientModel().getPossiblePropertyAt("Sources", "available");
        String current = (String)this.getClientModel().getPossiblePropertyAt("Sources", "current");
        this.inputSource.removeItemListener(this.itemListener);
        this.inputSource.removeAllItems();
        String[] stringArray = available;
        int n = available.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.inputSource.addItem(a);
            ++n2;
        }
        this.inputSource.setSelectedItem(current);
        this.inputSource.addItemListener(this.itemListener);
    }
}

