/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.impl.PrimeFinder;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.procore.cluster.IntHashTrait;

class TableIntHash
extends Table<int[]> {
    private static final int INITIAL_SIZE = 1000;
    private static final int ENTRY_SIZE = 3;
    protected static final int HeaderSize = 5;
    private static final int Capacity = -5;
    private static final int Size = -4;
    private static final int Free = -3;
    private static final int MaxInsert = -2;
    private static final int MaxRemove = -1;
    protected int[] ints;
    protected int hashBase;

    TableIntHash(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase);
        int capacity = PrimeFinder.nextPrime((int)1000);
        int tableSize = 3 * capacity + 5;
        this.createNewTable(tableSize, tableSize, 1);
        this.ints = (int[])this.getTable();
        this.hashBase = this.getTableBase() + 5;
        this.capacitySet(capacity);
        this.sizeSet(0);
        this.freeSet(capacity);
        this.computeMaxInsert(capacity);
        this.computeMaxRemove(this.maxInsertGet());
    }

    TableIntHash(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase, (Object)ints);
        this.ints = (int[])this.getTable();
        this.hashBase = this.getTableBase() + 5;
    }

    static final boolean isFree(int v) {
        return IntHashTrait.isFree(v);
    }

    static final boolean isFull(int v) {
        return IntHashTrait.isFull(v);
    }

    final boolean isFullByIndex(int index) {
        return TableIntHash.isFull(this.setGet(index));
    }

    static final boolean isRemoved(int v) {
        return IntHashTrait.isRemoved(v);
    }

    static final int setFree() {
        return IntHashTrait.setFree();
    }

    static final int setFull(int v) {
        return IntHashTrait.setFull(v);
    }

    static final int setRemoved() {
        return IntHashTrait.setRemoved();
    }

    final int capacityGet() {
        return this.ints[this.hashBase + -5];
    }

    final void capacitySet(int a) {
        this.ints[this.hashBase + -5] = a;
    }

    final int sizeGet() {
        return this.ints[this.hashBase + -4];
    }

    final void sizeSet(int a) {
        this.ints[this.hashBase + -4] = a;
    }

    final int freeGet() {
        return this.ints[this.hashBase + -3];
    }

    final void freeSet(int a) {
        this.ints[this.hashBase + -3] = a;
    }

    final int maxInsertGet() {
        return this.ints[this.hashBase + -2];
    }

    final void maxInsertSet(int a) {
        this.ints[this.hashBase + -2] = a;
    }

    final int maxRemoveGet() {
        return this.ints[this.hashBase + -1];
    }

    void maxRemoveSet(int a) {
        this.ints[this.hashBase + -1] = a;
    }

    final int setGet(int index) {
        return this.ints[this.hashBase + index * 3 + 2];
    }

    final void setSet(int index, int value) {
        this.ints[this.hashBase + index * 3 + 2] = value;
    }

    final void setKeyAndValue(int index, int key1, int key2, int value) {
        int realIndex = index * 3;
        this.ints[this.hashBase + realIndex] = key1;
        this.ints[this.hashBase + realIndex + 1] = key2;
        this.ints[this.hashBase + realIndex + 2] = value;
    }

    final boolean isFreeByIndex(int index) {
        return TableIntHash.isFree(this.ints[this.hashBase + index * 3 + 2]);
    }

    final boolean isRemovedByIndex(int index) {
        return TableIntHash.isRemoved(this.ints[this.hashBase + index * 3 + 2]);
    }

    final boolean isEqualByIndex(int index, int key1, int key2) {
        int realIndex = index * 3;
        return key1 == this.ints[this.hashBase + realIndex] && key2 == this.ints[this.hashBase + realIndex + 1];
    }

    final void computeMaxInsert(int capacity) {
        int maxSize = Math.min(capacity - 1, capacity >> 1);
        this.maxInsertSet(maxSize);
        this.freeSet(capacity - this.sizeGet());
    }

    final void computeMaxRemove(int removeCapacity) {
        this.maxRemoveSet((removeCapacity >> 1) + 1);
    }

    final int getValue(int key1, int key2) {
        int index = this.index(key1, key2);
        return index < 0 ? 0 : this.setGet(index);
    }

    final boolean removeValue(int key1, int key2) {
        int index = this.index(key1, key2);
        if (index < 0) {
            return false;
        }
        this.setSet(index, TableIntHash.setRemoved());
        return true;
    }

    final boolean setValue(int key1, int key2, int value) {
        assert (!TableIntHash.isFree(value));
        assert (!TableIntHash.isRemoved(value));
        int index = this.insertionIndex(key1, key2);
        boolean added = true;
        boolean isNewMapping = true;
        boolean previousStateWasFree = false;
        if (index < 0) {
            index = -index - 1;
            this.setSet(index, value);
            isNewMapping = false;
        } else {
            if (this.isFreeByIndex(index)) {
                previousStateWasFree = true;
            }
            this.setKeyAndValue(index, key1, key2, value);
        }
        if (isNewMapping) {
            this.postInsertHook(previousStateWasFree);
        }
        return added;
    }

    final int index(int akey1, int akey2) {
        int length = this.capacityGet();
        int hash = TableIntHash.computeHashCode(akey1, akey2);
        int index = hash % length;
        if (!(this.isFreeByIndex(index) || !this.isRemovedByIndex(index) && this.isEqualByIndex(index, akey1, akey2))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!this.isFreeByIndex(index) && (this.isRemovedByIndex(index) || !this.isEqualByIndex(index, akey1, akey2)));
        }
        return this.isFreeByIndex(index) ? -1 : index;
    }

    final int insertionIndex(int akey1, int akey2) {
        int length = this.capacityGet();
        int hash = TableIntHash.computeHashCode(akey1, akey2);
        int index = hash % length;
        if (this.isFreeByIndex(index)) {
            return index;
        }
        if (this.isFullByIndex(index) && this.isEqualByIndex(index, akey1, akey2)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (!this.isRemovedByIndex(index)) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (this.isFullByIndex(index) && !this.isEqualByIndex(index, akey1, akey2));
        }
        if (this.isRemovedByIndex(index)) {
            int firstRemoved = index;
            while (!(this.isFreeByIndex(index) || !this.isRemovedByIndex(index) && this.isEqualByIndex(index, akey1, akey2))) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return this.isFullByIndex(index) ? -index - 1 : firstRemoved;
        }
        return this.isFullByIndex(index) ? -index - 1 : index;
    }

    static final int computeHashCode(int key1, int key2) {
        int hash = key1 == key2 ? key1 * 31 : (key1 ^ key2) * 31;
        return hash & Integer.MAX_VALUE;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            this.freeSet(this.freeGet() - 1);
        }
        int size = this.sizeGet() + 1;
        this.sizeSet(size);
        int maxSize = this.maxInsertGet();
        int capacity = this.capacityGet();
        int free = this.freeGet();
        if (size > maxSize || free == 0) {
            int newCapacity = size > maxSize ? PrimeFinder.nextPrime((int)(capacity << 1)) : capacity;
            this.rehash(newCapacity);
        }
    }

    private final void rehash(int newCapacity) {
        int oldCapacity = this.capacityGet();
        int oldHashBase = this.hashBase;
        int newTableCapacity = newCapacity * 3 + 5;
        int[] oldInts = (int[])this.createNewTable(newTableCapacity, newTableCapacity, 1);
        this.ints = (int[])this.getTable();
        this.hashBase = this.getTableBase() + 5;
        this.capacitySet(newCapacity);
        this.sizeSet(0);
        this.freeSet(newCapacity);
        this.computeMaxInsert(newCapacity);
        this.computeMaxRemove(this.maxInsertGet());
        int i = oldCapacity;
        while (i-- > 0) {
            int realIndex = oldHashBase + i * 3;
            if (!TableIntHash.isFull(oldInts[realIndex + 2])) continue;
            int hashIndex = this.insertionIndex(oldInts[realIndex], oldInts[realIndex + 1]);
            assert (hashIndex >= 0);
            int value = oldInts[realIndex + 2];
            assert (!TableIntHash.isFree(value));
            assert (!TableIntHash.isRemoved(value));
            this.setKeyAndValue(hashIndex, oldInts[realIndex], oldInts[realIndex + 1], value);
        }
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}

