/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterWriteOnly;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.Utils;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.procedure.TIntShortProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteLogger;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterSmall;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.scl.runtime.function.FunctionImpl2;
import org.simantics.scl.runtime.function.FunctionImpl3;
import org.simantics.utils.Development;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugSupportImpl
implements DebugSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugSupportImpl.class);
    private final Map<String, Function2<WriteGraph, String, Object>> getCommands = new HashMap<String, Function2<WriteGraph, String, Object>>();
    private final Map<String, Function3<WriteGraph, File, String, String>> listCommands = new HashMap<String, Function3<WriteGraph, File, String, String>>();
    private final Map<String, Function2<WriteGraph, String, String>> execCommands = new HashMap<String, Function2<WriteGraph, String, String>>();
    private final Map<String, Function2<WriteGraph, String, String>> printCommands = new HashMap<String, Function2<WriteGraph, String, String>>();

    private static SessionImplSocket getSession(WriteGraph graph) {
        return (SessionImplSocket)graph.getSession();
    }

    DebugSupportImpl() {
        this.getCommands.put("listeners", (Function2<WriteGraph, String, Object>)new FunctionImpl2<WriteGraph, String, Object>(){

            public Object apply(WriteGraph graph, String args) {
                try {
                    return DebugSupportImpl.getSession((WriteGraph)graph).queryProvider2.listening.getListenerReport();
                }
                catch (IOException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("counters", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                try {
                    return ReadGraphImpl.listCounters((File)file);
                }
                catch (IOException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("queries", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                try {
                    return DebugSupportImpl.getSession((WriteGraph)graph).queryProvider2.reportQueries(file);
                }
                catch (IOException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("queryData", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                try {
                    DebugSupportImpl.getSession((WriteGraph)graph).queryProvider2.save();
                    return "Saved queries";
                }
                catch (IOException e) {
                    LOGGER.error("Error while saving queries", (Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("queryActivity", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                try {
                    return DebugSupportImpl.getSession((WriteGraph)graph).queryProvider2.reportQueryActivity(file);
                }
                catch (IOException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("listeners", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                try {
                    return DebugSupportImpl.getSession((WriteGraph)graph).queryProvider2.listening.reportListeners(file);
                }
                catch (IOException e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return e.getMessage();
                }
            }
        });
        this.listCommands.put("clusters", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                return DebugSupportImpl.this.reportClusters(DebugSupportImpl.getSession(graph), file);
            }
        });
        this.listCommands.put("cluster", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                return DebugSupportImpl.this.reportCluster(graph, file, args);
            }
        });
        this.listCommands.put("virtuals", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                return DebugSupportImpl.this.reportVirtuals(DebugSupportImpl.getSession(graph), file);
            }
        });
        this.listCommands.put("heap", (Function3<WriteGraph, File, String, String>)new FunctionImpl3<WriteGraph, File, String, String>(){

            public String apply(WriteGraph graph, File file, String args) {
                Object bean;
                block5: {
                    try {
                        file.delete();
                        bean = this.getBean();
                        if (bean != null) break block5;
                        return "Could not retrieve bean.";
                    }
                    catch (Throwable t) {
                        org.simantics.db.common.utils.Logger.defaultLogError((Throwable)t);
                        return "Unexpected exception " + t;
                    }
                }
                Method m = bean.getClass().getMethod("dumpHeap", String.class, Boolean.TYPE);
                if (args.length() > 0) {
                    m.invoke(bean, String.valueOf(file.getParent()) + "/" + args, true);
                } else {
                    m.invoke(bean, file.getAbsolutePath(), true);
                }
                return "Wrote " + file.getAbsolutePath();
            }

            private Object getBean() {
                Class<?> beanClass = this.getBeanClass();
                if (beanClass == null) {
                    return null;
                }
                try {
                    Object bean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", beanClass);
                    return bean;
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            private Class<?> getBeanClass() {
                try {
                    Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
        this.execCommands.put("WriteLogger.read", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                graph.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        try {
                            WriteLogger.read((WriteGraph)graph);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                return "Started to read the write log.";
            }
        });
        this.execCommands.put("ReadGraph.resetCounters", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                graph.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        try {
                            ReadGraphImpl.resetCounters();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                return "Started to read the write log.";
            }
        });
        this.execCommands.put("QueryControl.flush", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                qc.flush((ReadGraph)graph);
                return "Flushed queries.";
            }
        });
        this.execCommands.put("DebugSupport.validateClusters", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                return DebugSupportImpl.this.validateClusters(graph);
            }
        });
        this.execCommands.put("DebugSupport.writeForMs", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                Integer amount = Integer.parseInt(args);
                return DebugSupportImpl.this.writeForMs(graph, amount);
            }
        });
        this.printCommands.put("nextId", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                try {
                    SessionImplSocket session = DebugSupportImpl.getSession(graph);
                    ClusterImpl cluster = session.clusterTable.getNewResourceCluster((ClusterSupport)session.clusterTranslator, session.graphSession, false);
                    long cid = cluster.getClusterId();
                    int rid = cluster.getNumberOfResources((ClusterSupport)session.clusterTranslator);
                    return String.valueOf(cid) + "#" + rid;
                }
                catch (Throwable throwable) {
                    return UUID.randomUUID().toString();
                }
            }
        });
        this.printCommands.put("usedMemory", (Function2<WriteGraph, String, String>)new FunctionImpl2<WriteGraph, String, String>(){

            public String apply(WriteGraph graph, String args) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    return "" + (runtime.totalMemory() - runtime.freeMemory());
                }
                catch (Throwable throwable) {
                    return UUID.randomUUID().toString();
                }
            }
        });
    }

    private String reportClusters(SessionImplSocket session, File file) {
        try {
            StringBuilder b = new StringBuilder();
            long totalApproxSize = 0L;
            int loaded = 0;
            for (ClusterI cluster : session.clusterTable.getClusters()) {
                b.append("[" + cluster.getClusterKey() + "]: ");
                if (cluster instanceof ClusterSmall) {
                    b.append("ClusterSmall[" + cluster.getClusterId() + "]");
                }
                if (cluster instanceof ClusterBig) {
                    b.append("ClusterBig[" + cluster.getClusterId() + "]");
                }
                if (cluster instanceof ClusterWriteOnly) {
                    b.append("ClusterWriteOnly[" + cluster.getClusterId() + "]");
                }
                if (cluster.isLoaded()) {
                    long approx = cluster.getUsedSpace();
                    b.append(" approx size = " + approx + " bytes.\n");
                    totalApproxSize += approx;
                    ++loaded;
                    continue;
                }
                b.append(" is not loaded.\n");
            }
            b.append("#Total approx size is " + totalApproxSize + " bytes.\n");
            b.append("#Amount of loaded clusters is " + loaded + ".\n");
            FileUtils.writeFile((File)file, (byte[])b.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return "OK";
    }

    private String reportCluster(final WriteGraph graph, File file, String args) {
        try {
            final StringBuilder b = new StringBuilder();
            final SessionImplSocket session = (SessionImplSocket)graph.getSession();
            long clusterId = Long.parseLong(args);
            b.append("cluster id: " + clusterId);
            b.append("\n");
            b.append("internal resources: ");
            b.append("\n");
            ClusterImpl cluster = session.clusterTable.getClusterByClusterId(clusterId);
            int i = 1;
            while (i <= cluster.getNumberOfResources((ClusterSupport)session.clusterTranslator)) {
                ResourceImpl r = session.getResource(i, clusterId);
                String def = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                b.append(String.valueOf(i) + ": " + def);
                b.append("\n");
                ++i;
            }
            if (cluster instanceof ClusterSmall) {
                ClusterSmall clusterSmall = (ClusterSmall)cluster;
                b.append("foreign resources: ");
                b.append("\n");
                final TIntIntHashMap clusterHistogram = new TIntIntHashMap();
                clusterSmall.foreignTable.getResourceHashMap().forEachEntry(new TIntShortProcedure(){

                    public boolean execute(int index, short pos) {
                        try {
                            ResourceImpl r = session.getResource(index);
                            String def = NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true);
                            int cluster = index >>> 12;
                            int key = index & 0xFFF;
                            int exist = clusterHistogram.get(cluster);
                            clusterHistogram.put(cluster, exist + 1);
                            b.append(String.valueOf(cluster) + "$" + key + ": " + def);
                            b.append("\n");
                        }
                        catch (ValidationException e) {
                            e.printStackTrace();
                        }
                        catch (ServiceException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                });
                b.append("foreign histogram: ");
                b.append("\n");
                clusterHistogram.forEachEntry(new TIntIntProcedure(){

                    public boolean execute(int cluster, int count) {
                        b.append(String.valueOf(cluster) + ": " + count);
                        b.append("\n");
                        return true;
                    }
                });
            }
            FileUtils.writeFile((File)file, (byte[])b.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return "OK";
    }

    private String reportVirtuals(SessionImplSocket session, File file) {
        session.virtualGraphServerSupport.report(file);
        return "OK";
    }

    public Object query(Session session, final String command) {
        try {
            return session.sync((WriteInterface)new WriteResultRequest<Object>(){

                public Object perform(WriteGraph graph) throws DatabaseException {
                    return DebugSupportImpl.this.query(graph, command);
                }
            });
        }
        catch (DatabaseException e) {
            org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public Object query(WriteGraph graph, String command) {
        File base;
        block27: {
            Bundle bundle = Platform.getBundle((String)"org.simantics.db.impl");
            base = Utils.getBaseFile(bundle);
            command = command.trim();
            if (!"help".equals(command)) break block27;
            return "Welcome to the Simantics session debugger.<br><br>This shell allows you to make following queries into the running Simantics database session:<br><ul><li>Get commands, which return debug objects. Type 'help get' to obtain more information.</li><li>List commands, which create debug listings into files. Type 'help list' to obtain more information.</li><li>Print commands, which output information about session state. Type 'help print' to obtain more information.</li><li>Set commands, which modify session state variables. Type 'help set' to obtain more information.</li><li>Exec commands, which perform certain actions. Type 'help exec' to obtain more information.</li></ul>";
        }
        try {
            if ("help get".equals(command)) {
                StringBuilder b = new StringBuilder();
                b.append("The following get commands are available.<br><ul>");
                for (String key : this.getCommands.keySet()) {
                    b.append("<li>" + key + "</li>");
                }
                b.append("</ul>");
                return b.toString();
            }
            if ("help list".equals(command)) {
                StringBuilder b = new StringBuilder();
                b.append("The following list commands are available.<br><ul>");
                for (String key : this.listCommands.keySet()) {
                    b.append("<li>" + key + "</li>");
                }
                b.append("</ul>");
                return b.toString();
            }
            if ("help exec".equals(command)) {
                StringBuilder b = new StringBuilder();
                b.append("The following exec commands are available.<br><ul>");
                for (String key : this.execCommands.keySet()) {
                    b.append("<li>" + key + "</li>");
                }
                b.append("</ul>");
                return b.toString();
            }
            if ("help print".equals(command)) {
                StringBuilder b = new StringBuilder();
                b.append("The following print commands are available.<br><ul>");
                for (String key : this.printCommands.keySet()) {
                    b.append("<li>" + key + "</li>");
                }
                b.append("</ul>");
                return b.toString();
            }
            if ("help set".equals(command)) {
                StringBuilder b = new StringBuilder();
                b.append("The following set commands are available.<br><ul>");
                for (Map.Entry e : Development.getProperties().entrySet()) {
                    b.append("<li>" + (String)e.getKey() + " - " + ((Variant)e.getValue()).getBinding().type() + "</li>");
                }
                b.append("</ul>");
                return b.toString();
            }
            if (command.startsWith("get")) {
                String remainder = command.substring(3).trim();
                for (Map.Entry<String, Function2<WriteGraph, String, Object>> e : this.getCommands.entrySet()) {
                    String key = e.getKey();
                    if (!remainder.startsWith(key)) continue;
                    String args = remainder.substring(key.length()).trim();
                    return e.getValue().apply((Object)graph, (Object)args);
                }
            } else if (command.startsWith("list")) {
                String remainder = command.substring(4).trim();
                for (Map.Entry<String, Function3<WriteGraph, File, String, String>> e : this.listCommands.entrySet()) {
                    String key = e.getKey();
                    if (!remainder.startsWith(key)) continue;
                    String args = remainder.substring(key.length()).trim();
                    File file = new File(base, String.valueOf(key) + ".list");
                    base.mkdirs();
                    e.getValue().apply((Object)graph, (Object)file, (Object)args);
                    return "Wrote " + file.getAbsolutePath();
                }
            } else {
                if (command.startsWith("set")) {
                    String remainder = command.substring(3).trim();
                    String[] keyAndValue = remainder.split("=");
                    if (keyAndValue.length == 2) {
                        Variant exist = (Variant)Development.getProperties().get(keyAndValue[0]);
                        if (exist != null) {
                            Development.setProperty((String)keyAndValue[0], (Object)exist.getBinding().parseValue(keyAndValue[1], new DataValueRepository()), (Binding)exist.getBinding());
                            return "Property " + keyAndValue[0] + " was set to '" + keyAndValue[1] + "'";
                        }
                        return this.query(graph, "help set");
                    }
                    return this.query(graph, "help set");
                }
                if (command.startsWith("print")) {
                    String remainder = command.substring(5).trim();
                    for (Map.Entry<String, Function2<WriteGraph, String, String>> e : this.printCommands.entrySet()) {
                        String key = e.getKey();
                        if (!remainder.startsWith(key)) continue;
                        String args = remainder.substring(key.length()).trim();
                        return e.getValue().apply((Object)graph, (Object)args);
                    }
                } else if (command.startsWith("exec")) {
                    String remainder = command.substring(4).trim();
                    for (Map.Entry<String, Function2<WriteGraph, String, String>> e : this.execCommands.entrySet()) {
                        String key = e.getKey();
                        if (!remainder.startsWith(key)) continue;
                        String args = remainder.substring(key.length()).trim();
                        return e.getValue().apply((Object)graph, (Object)args);
                    }
                }
            }
            return "Unknown command '" + command + "'";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return t.getMessage();
        }
    }

    private void writeResouce(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource r = graph.newResource();
        graph.claim(r, l0.InstanceOf, l0.Entity);
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        xs.flushCluster(r);
    }

    private void wait(int amount) {
        long start = System.nanoTime();
        long limit = (long)amount * 1000000L;
        while (System.nanoTime() - start < limit) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    String writeForMs(WriteGraph graph, int amount) {
        try {
            this.writeResouce(graph);
            this.wait(amount);
            this.writeResouce(graph);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return "Slept for " + amount + " ms in write transaction.";
    }

    String validateClusters(WriteGraph graph) {
        ReadGraphImpl impl = (ReadGraphImpl)graph;
        QueryProcessor processor = impl.processor;
        QuerySupport qs = (QuerySupport)graph.getService(QuerySupport.class);
        TIntHashSet done = new TIntHashSet();
        TreeSet<Integer> fringe = new TreeSet<Integer>();
        ResourceImpl root = (ResourceImpl)graph.getRootLibrary();
        done.add(root.id);
        fringe.add(root.id);
        while (!fringe.isEmpty()) {
            int r = (Integer)fringe.first();
            fringe.remove(r);
            DirectStatements ds = qs.getStatements(impl, r, processor, true);
            for (Statement stm : ds) {
                ResourceImpl p = (ResourceImpl)stm.getPredicate();
                ResourceImpl o = (ResourceImpl)stm.getObject();
                if (done.add(p.id)) {
                    fringe.add(p.id);
                }
                if (!done.add(o.id)) continue;
                fringe.add(o.id);
            }
            qs.getValue(impl, r);
        }
        return "Validated " + done.size() + " resources.";
    }
}

