/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HeaderWithUnderlineRule
implements IRule {
    IToken successToken = null;

    public HeaderWithUnderlineRule(IToken token) {
        this.successToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = -1;
        int scanCount = 0;
        if (scanner.getColumn() == 0) {
            do {
                c = scanner.read();
                ++scanCount;
            } while (!this.isNewLine((char)c) && c != -1);
            if (c == -1) {
                int i = 0;
                while (i < scanCount) {
                    scanner.unread();
                    ++i;
                }
                return Token.UNDEFINED;
            }
            c = scanner.read();
            ++scanCount;
            if (c == 13) {
                c = scanner.read();
                ++scanCount;
            }
            if (!this.isUnderline((char)c)) {
                int i = 0;
                while (i < scanCount) {
                    scanner.unread();
                    ++i;
                }
                return Token.UNDEFINED;
            }
            do {
                c = scanner.read();
                ++scanCount;
                if (!this.isNewLine((char)c) && c != -1) continue;
                return this.successToken;
            } while (this.isUnderline((char)c) || this.isWhitespace((char)c) || c == 13);
            int i = 0;
            while (i < scanCount) {
                scanner.unread();
                ++i;
            }
            return Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    boolean isNewLine(char c) {
        return c == '\n';
    }

    boolean isUnderline(char c) {
        return c == '=' || c == '-';
    }

    boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }
}

