/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.ontology;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;

public class WorkbenchResource {
    public final Resource DependenciesSearchContribution;
    public final Resource DependenciesSearchFunction;
    public final Resource HasWorkbenchSearchFunction;
    public final Resource SearchContribution;
    public final Resource SearchContribution_isEnabledByDefault;
    public final Resource SearchContribution_isEnabledByDefault_Inverse;
    public final Resource SearchFunction;
    public final Resource hasSearchFunction;

    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        }
        catch (DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public WorkbenchResource(ReadGraph graph) {
        this.DependenciesSearchContribution = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/DependenciesSearchContribution");
        this.DependenciesSearchFunction = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/DependenciesSearchFunction");
        this.HasWorkbenchSearchFunction = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/HasWorkbenchSearchFunction");
        this.SearchContribution = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/SearchContribution");
        this.SearchContribution_isEnabledByDefault = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault");
        this.SearchContribution_isEnabledByDefault_Inverse = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault/Inverse");
        this.SearchFunction = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/SearchFunction");
        this.hasSearchFunction = WorkbenchResource.getResourceOrNull(graph, "http://www.simantics.org/Workbench-1.2/hasSearchFunction");
    }

    public static WorkbenchResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        WorkbenchResource ret = (WorkbenchResource)session.peekService(WorkbenchResource.class);
        if (ret == null) {
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            ret = new WorkbenchResource(qc.getIndependentGraph(graph));
            session.registerService(WorkbenchResource.class, (Object)ret);
        }
        return ret;
    }

    public static WorkbenchResource getInstance(RequestProcessor session) throws DatabaseException {
        WorkbenchResource ret = (WorkbenchResource)session.peekService(WorkbenchResource.class);
        if (ret == null) {
            ret = (WorkbenchResource)session.syncRequest((Read)new Read<WorkbenchResource>(){

                public WorkbenchResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                    return new WorkbenchResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(WorkbenchResource.class, (Object)ret);
        }
        return ret;
    }

    public static class URIs {
        public static final String DependenciesSearchContribution = "http://www.simantics.org/Workbench-1.2/DependenciesSearchContribution";
        public static final String DependenciesSearchFunction = "http://www.simantics.org/Workbench-1.2/DependenciesSearchFunction";
        public static final String HasWorkbenchSearchFunction = "http://www.simantics.org/Workbench-1.2/HasWorkbenchSearchFunction";
        public static final String SearchContribution = "http://www.simantics.org/Workbench-1.2/SearchContribution";
        public static final String SearchContribution_isEnabledByDefault = "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault";
        public static final String SearchContribution_isEnabledByDefault_Inverse = "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault/Inverse";
        public static final String SearchFunction = "http://www.simantics.org/Workbench-1.2/SearchFunction";
        public static final String hasSearchFunction = "http://www.simantics.org/Workbench-1.2/hasSearchFunction";
    }
}

