/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.text.internal;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.wikitext.mediawiki.MediaWikiLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewer;
import org.eclipse.mylyn.wikitext.ui.editor.MarkupSourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.ui.editor.ShowInTargetBridge;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.swt.IFocusService;
import org.simantics.views.ViewUtils;
import org.simantics.views.swt.client.base.SingleSWTViewNode;
import org.simantics.views.text.internal.Activator;

public class SWTMarkupSourceViewer
extends SingleSWTViewNode<StyledText> {
    private static final long serialVersionUID = 3034624586096417826L;
    private MarkupSourceViewer viewer;
    private boolean textInitialized = false;

    public void createControls(Composite parent) {
        IFocusService focusService;
        MediaWikiLanguage language = new MediaWikiLanguage();
        this.viewer = new MarkupSourceViewer(parent, null, this.style | 0x40, (MarkupLanguage)language);
        this.viewer.setEditable(false);
        MarkupSourceViewerConfiguration configuration = new MarkupSourceViewerConfiguration(Activator.getDefault().getPreferenceStore());
        configuration.setMarkupLanguage((MarkupLanguage)language);
        configuration.setShowInTarget((IShowInTarget)new ShowInTargetBridge((SourceViewer)this.viewer));
        this.viewer.configure((SourceViewerConfiguration)configuration);
        this.viewer.setDocument((IDocument)new Document(this.text != null ? this.text : ""));
        this.control = this.viewer.getTextWidget();
        ((StyledText)this.control).setData("undoManager", (Object)this.viewer.getUndoManager());
        ((StyledText)this.control).setEnabled(false);
        this.setProperties();
        IWorkbenchSite locator = this.getSite();
        if (locator != null && (focusService = (IFocusService)locator.getService(IFocusService.class)) != null) {
            focusService.addFocusTracker(this.control, "inTextViewer");
        }
        ((StyledText)this.control).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewUtils.setWorkbenchSelection((ISelection)SWTMarkupSourceViewer.this.viewer.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    public void synchronizeText(String text) {
        this.text = text;
        if (text != null) {
            int caretOffset = ((StyledText)this.control).getCaretOffset();
            int charCount = ((StyledText)this.control).getCharCount();
            int topIndex = this.viewer.getTopIndex();
            int diff = text.length() - charCount;
            int newCaretOffset = Math.max(0, Math.min(caretOffset + diff, text.length()));
            this.viewer.getDocument().set(text);
            this.viewer.setTopIndex(topIndex);
            ((StyledText)this.control).setCaretOffset(newCaretOffset);
            this.viewer.setEditable(true);
            ((StyledText)this.control).setEnabled(true);
            if (!this.textInitialized) {
                this.viewer.getUndoManager().reset();
                this.textInitialized = true;
            }
        } else {
            this.textInitialized = false;
            this.viewer.setEditable(false);
            ((StyledText)this.control).setEnabled(false);
            this.viewer.getDocument().set("");
            this.viewer.getUndoManager().reset();
        }
    }

    public String readText() {
        return this.viewer.getDocument().get();
    }

    public Point readSelection() {
        return ((StyledText)this.control).getSelection();
    }
}

