/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.impl;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.datatypes.literal.RGB;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.colors.Colors;
import org.simantics.utils.ui.widgets.ITrackedColorProvider;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;
import org.simantics.utils.ui.widgets.TrackedText;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTTrackedText
extends SingleSWTViewNode<Text> {
    private static final RGB.Integer WHITE = new RGB.Integer(255, 255, 255);
    private static final long serialVersionUID = 7932335224632082902L;
    private TrackedText tt;
    protected Color invalidBackgroundColor;
    protected Color inactiveBackgroundColor;
    protected Color hoverBackgroundColor;
    protected Color editingBackgroundColor;
    public Function1<String, String> modifier;
    public Function1<String, String> validator;
    public RGB.Integer invalidBackground = WHITE;
    public RGB.Integer inactiveBackground = WHITE;
    public RGB.Integer hoverBackground = WHITE;
    public RGB.Integer editingBackground = WHITE;
    protected ArrayList<TrackedModifyListener> listeners = new ArrayList();

    public void addModifyListener(TrackedModifyListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void createControls(Composite parent) {
        this.tt = new TrackedText(parent, this.style);
        this.control = this.tt.getWidget();
        this.setProperties();
        this.tt.setColorProvider(new ITrackedColorProvider(){

            public Color getInvalidBackground() {
                return SWTTrackedText.this.invalidBackgroundColor;
            }

            public Color getInactiveBackground() {
                return SWTTrackedText.this.inactiveBackgroundColor;
            }

            public Color getHoverBackground() {
                return SWTTrackedText.this.hoverBackgroundColor;
            }

            public Color getEditingBackground() {
                return SWTTrackedText.this.editingBackgroundColor;
            }
        });
        this.tt.setInputValidator(new IInputValidator(){

            public String isValid(String newText) {
                if (SWTTrackedText.this.validator != null) {
                    return (String)SWTTrackedText.this.validator.apply((Object)newText);
                }
                return null;
            }
        });
        this.tt.addModifyListener(new TrackedModifyListener(){

            public void modifyText(TrackedModifyEvent e) {
                if (SWTTrackedText.this.modifier != null) {
                    SWTTrackedText.this.modifier.apply((Object)e.getText());
                }
                for (TrackedModifyListener listener : SWTTrackedText.this.listeners) {
                    listener.modifyText(e);
                }
            }
        });
    }

    @Override
    public void synchronizeText(String text) {
        if (text != null) {
            ((Text)this.control).setText(text);
        }
    }

    public final void synchronizeInvalidBackground(RGB.Integer invalidBackground) {
        if (invalidBackground != null) {
            this.invalidBackgroundColor = Colors.swt((Device)((Text)this.control).getDisplay(), (RGB.Integer)invalidBackground);
        }
    }

    public final void synchronizeInactiveBackground(RGB.Integer inactiveBackground) {
        if (inactiveBackground != null) {
            this.inactiveBackgroundColor = Colors.swt((Device)((Text)this.control).getDisplay(), (RGB.Integer)inactiveBackground);
        }
    }

    public final void synchronizeHoverBackground(RGB.Integer hoverBackground) {
        if (hoverBackground != null) {
            this.hoverBackgroundColor = Colors.swt((Device)((Text)this.control).getDisplay(), (RGB.Integer)hoverBackground);
        }
    }

    public final void synchronizeEditingBackground(RGB.Integer editingBackground) {
        if (editingBackground != null) {
            this.editingBackgroundColor = Colors.swt((Device)((Text)this.control).getDisplay(), (RGB.Integer)editingBackground);
        }
    }

    public final void synchronizeValidator(Function1<String, String> validator) {
    }

    public final void synchronizeModifier(Function1<String, String> modifier) {
    }
}

