/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt.client.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.utils.ui.jface.BasePostSelectionProvider;
import org.simantics.views.ViewUtils;
import org.simantics.views.swt.client.base.ISWTViewNode;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTTabFolder
extends SingleSWTViewNode<CTabFolder> {
    private static final long serialVersionUID = -8003676031533344133L;
    public List<String> childNames;
    public ViewUtils.LayoutBean layout;
    final BasePostSelectionProvider selectionProvider = new BasePostSelectionProvider();
    ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SWTTabFolder.this.selectionProvider.firePostSelection(event.getSelection());
        }
    };

    private CTabItem createItem(int index, CTabFolder folder, Control control) {
        CTabItem item = new CTabItem(folder, 0, index);
        item.setControl(control);
        return item;
    }

    @Override
    public void createControls(Composite parent) {
        this.control = new CTabFolder(parent, 0x800400);
        this.setProperties();
        this.createChildComposites();
        this.updateFolder();
    }

    protected void childrenChanged() {
        if (this.control != null && !((CTabFolder)this.control).isDisposed()) {
            this.updateFolder();
        }
    }

    protected void updateFolder() {
        assert (this.childNames != null);
        HashSet<Control> existing = new HashSet<Control>();
        CTabItem[] cTabItemArray = ((CTabFolder)this.control).getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem c = cTabItemArray[n2];
            existing.add(c.getControl());
            ++n2;
        }
        int index = existing.size();
        boolean hasSomeSelectionProviders = false;
        for (ISWTViewNode node : this.getChildComposites()) {
            Control c = node.getControl();
            if (c == null || existing.contains(c)) continue;
            CTabItem item = this.createItem(index, (CTabFolder)this.control, c);
            item.setText(this.childNames.get(index++));
            for (Control c2 : this.getControls(item)) {
                if (!(c2 instanceof GraphExplorerComposite)) continue;
                GraphExplorerComposite gec = (GraphExplorerComposite)c2;
                ISelectionProvider sp = (ISelectionProvider)gec.getAdapter(ISelectionProvider.class);
                sp.addSelectionChangedListener(this.selectionListener);
                hasSomeSelectionProviders = true;
            }
        }
        if (hasSomeSelectionProviders) {
            this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        }
        ((CTabFolder)this.control).setSelection(0);
        ((CTabFolder)this.control).update();
    }

    Set<Control> getControls(CTabItem item) {
        HashSet<Control> result = new HashSet<Control>();
        this.forControl(item.getControl(), result);
        return result;
    }

    void forControl(Control control, HashSet<Control> controls) {
        controls.add(control);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.forControl(child, controls);
                ++n2;
            }
        }
    }

    public void synchronizeChildNames(List<String> childNames) {
    }

    public final void synchronizeLayout(ViewUtils.LayoutBean layout) {
    }
}

