package org.simantics.views.swt.client.impl;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.views.swt.client.base.SingleSWTViewNode;

public class SWTText extends SingleSWTViewNode<Text> {
	
	private static final long serialVersionUID = 7932335224632082902L;
	
	@Override
	public void createControls(Composite parent) {
		
		control = new Text(parent, style);
		control.setEnabled(false);
		setProperties();
		
	}
	
	@Override
	public void synchronizeText(String text) {
		if(text != null) {
			control.setText(text);
			control.setEnabled(true);
			control.getParent().layout();
		} else {
			control.setText("");
			control.setEnabled(false);
			control.getParent().layout();
		}
	}
	
	public String readText() {
		return control.getText();
	}
	
	public Point readSelection() {
		return control.getSelection();
	}

}
