package org.simantics.views.swt.client.base;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Layout;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.Column.Align;
import org.simantics.views.ViewUtils.ColumnBean;
import org.simantics.views.ViewUtils.GridDataBean;
import org.simantics.views.ViewUtils.GridLayoutBean;
import org.simantics.views.ViewUtils.LayoutBean;
import org.simantics.views.ViewUtils.LayoutDataBean;
import org.simantics.views.ViewUtils.RowDataBean;
import org.simantics.views.ViewUtils.RowLayoutBean;

public class SWTViewUtils {

	public static Layout toLayout(GridLayoutBean bean) {
		GridLayout result = GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).margins(0, 0).spacing(0, 0).create();
		result.numColumns = bean.numColumns;
		result.horizontalSpacing = bean.horizontalSpacing;
		result.verticalSpacing = bean.verticalSpacing;
		result.marginLeft = bean.marginLeft;
		result.marginRight = bean.marginRight;
		result.marginTop = bean.marginTop;
		result.marginBottom = bean.marginBottom;
		return result;
	}

	public static Layout toLayout(RowLayoutBean bean) {
		RowLayout result = RowLayoutFactory.fillDefaults().create();
		result.type = bean.type;
		result.spacing = bean.spacing;
		result.center = bean.center;
		result.fill = bean.fill;
		result.justify = bean.justify;
		result.pack = bean.pack;
		result.wrap = bean.wrap;
		result.marginLeft = bean.marginLeft;
		result.marginRight = bean.marginRight;
		result.marginTop = bean.marginTop;
		result.marginBottom = bean.marginBottom;
		return result;
	}

	public static GridData toGridData(GridDataBean bean) {
		GridData result = new GridData(SWT.FILL, SWT.FILL, true, false);
		result.horizontalSpan = bean.horizontalSpan;
		result.grabExcessHorizontalSpace = bean.grabExcessHorizontalSpace;
		result.grabExcessVerticalSpace = bean.grabExcessVerticalSpace;
		result.horizontalAlignment = bean.horizontalAlignment;
		result.verticalAlignment = bean.verticalAlignment;
		result.widthHint = bean.widthHint;
		result.heightHint = bean.heightHint;
		return result;
		
	}

	public static RowData toRowData(RowDataBean bean) {
		return new RowData(bean.width, bean.height);
	}

	public static Layout toLayout(LayoutBean layout) {
		if (layout instanceof GridLayoutBean)
			return toLayout((GridLayoutBean) layout);
		if (layout instanceof RowLayoutBean)
			return toLayout((RowLayoutBean) layout);
		throw new IllegalArgumentException("unrecognized layout: " + layout);
	}


	public static Object toLayoutData(LayoutDataBean layoutData) {
		if (layoutData instanceof GridDataBean)
			return toGridData((GridDataBean) layoutData);
		if (layoutData instanceof RowDataBean)
			return toRowData((RowDataBean) layoutData);
		throw new IllegalArgumentException("unrecognized layout data: " + layoutData);
	}

	private static Align getAlign(String alignment) {
		if("LEFT".equals(alignment)) return Align.LEFT;
		else if("CENTER".equals(alignment)) return Align.CENTER;
		else if("RIGHT".equals(alignment)) return Align.RIGHT;
		else throw new IllegalArgumentException("Align should be either LEFT, CENTER or RIGHT (was " + alignment + ")");
	}
	
	public static Column toColumn(ColumnBean bean) {
		Align align = getAlign(bean.alignment);
		return new Column(bean.key, bean.label, align, bean.width, bean.tooltip, bean.grab, bean.weight);
	}
	
}
