/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx.clipboard.streams;

import java.io.IOException;
import java.io.InputStream;
import org.simantics.utils.ui.gfx.clipboard.headers.BitmapInfoHeader;

public class UncompressedDIBInputStream
extends InputStream {
    private InputStream iStream;
    private int readBytes = 0;
    private byte[] header;

    public UncompressedDIBInputStream(InputStream iStream) throws IOException {
        this.iStream = iStream;
        this.header = new byte[40];
        iStream.read(this.header, 0, 40);
        BitmapInfoHeader infoHeader = new BitmapInfoHeader();
        infoHeader.setBytes(this.header);
        if (infoHeader.biCompression == 3) {
            throw new IOException("BI_BITFIELDS stream not supported");
        }
        if (infoHeader.biCompression == 4) {
            throw new IOException("BI_JPEG stream not supported");
        }
        if (infoHeader.biCompression == 5) {
            throw new IOException("BI_PNG stream not supported");
        }
        if (infoHeader.biCompression == 1) {
            throw new IOException("BI_RLE8 stream not supported");
        }
        if (infoHeader.biCompression == 2) {
            throw new IOException("BI_RLE24 stream not supported");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.readBytes < this.header.length) {
            return 0xFF & this.header[this.readBytes++];
        }
        return this.iStream.read();
    }
}

