/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx.clipboard.streams;

import java.io.IOException;
import java.io.OutputStream;

public class RemoveBitmapHeaderOutputStream
extends OutputStream {
    private OutputStream oStream;
    private int byteCount = 0;

    public RemoveBitmapHeaderOutputStream(OutputStream oStream) {
        this.oStream = oStream;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.byteCount >= 14) {
            super.write(b);
        } else if (b.length >= 14 - this.byteCount) {
            byte[] newArray = new byte[b.length - 14 + this.byteCount];
            System.arraycopy(b, 14 - this.byteCount, newArray, 0, newArray.length);
            this.byteCount = 14;
            super.write(newArray);
        } else {
            this.byteCount += b.length;
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.byteCount < 14) {
            throw new IOException("Operation not supported, cannot remove header");
        }
        super.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.byteCount >= 14) {
            this.oStream.write(b);
        } else {
            ++this.byteCount;
        }
    }
}

