/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

public final class PixelFormat {
    public static PixelFormat RGB24 = new PixelFormat(255, 65280, 0xFF0000, 0);
    private final int redMask;
    private final int greenMask;
    private final int blueMask;
    private final int alphaMask;
    private final int redHighBit;
    private final int greenHighBit;
    private final int blueHighBit;
    private final int alphaHighBit;
    private final int redLowBit;
    private final int greenLowBit;
    private final int blueLowBit;
    private final int alphaLowBit;
    private final int bitDepth;

    public PixelFormat(int redMask, int greenMask, int blueMask, int alphaMask) {
        this.redMask = redMask;
        this.greenMask = greenMask;
        this.blueMask = blueMask;
        this.alphaMask = alphaMask;
        this.redHighBit = PixelFormat.findHighestBit(redMask);
        this.greenHighBit = PixelFormat.findHighestBit(greenMask);
        this.blueHighBit = PixelFormat.findHighestBit(blueMask);
        this.alphaHighBit = PixelFormat.findHighestBit(alphaMask);
        this.redLowBit = PixelFormat.findLowestBit(redMask);
        this.greenLowBit = PixelFormat.findLowestBit(greenMask);
        this.blueLowBit = PixelFormat.findLowestBit(blueMask);
        this.alphaLowBit = PixelFormat.findLowestBit(alphaMask);
        this.bitDepth = PixelFormat.findHighestBit(redMask | greenMask | blueMask | alphaMask) + 1;
    }

    public boolean hasAlpha() {
        return this.alphaMask != 0;
    }

    static int calculateShiftFromMask(int mask) {
        return 7 - PixelFormat.findHighestBit(mask);
    }

    static int findHighestBit(int mask) {
        int i = 31;
        while (i >= 0) {
            if ((mask & 1 << i) > 0) {
                return i;
            }
            --i;
        }
        return 0;
    }

    static int findLowestBit(int mask) {
        int i = 0;
        while (i < 32) {
            if ((mask & 1 << i) > 0) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getAlphaMask() {
        return this.alphaMask;
    }

    public int getAlphaShift() {
        return 7 - this.alphaHighBit;
    }

    public int getAlphaDepth() {
        return this.alphaHighBit - this.alphaLowBit + 1;
    }

    public int getAlphaHighBit() {
        return this.alphaHighBit;
    }

    public int getAlphaLowBit() {
        return this.alphaLowBit;
    }

    public int getBlueMask() {
        return this.blueMask;
    }

    public int getBlueShift() {
        return 7 - this.blueHighBit;
    }

    public int getBlueDepth() {
        return this.blueHighBit - this.blueLowBit + 1;
    }

    public int getBlueHighBit() {
        return this.blueHighBit;
    }

    public int getBlueLowBit() {
        return this.blueLowBit;
    }

    public int getGreenMask() {
        return this.greenMask;
    }

    public int getGreenShift() {
        return 7 - this.greenHighBit;
    }

    public int getGreenDepth() {
        return this.greenHighBit - this.greenLowBit + 1;
    }

    public int getGreenHighBit() {
        return this.greenHighBit;
    }

    public int getGreenLowBit() {
        return this.greenLowBit;
    }

    public int getRedMask() {
        return this.redMask;
    }

    public int getRedShift() {
        return 7 - this.redHighBit;
    }

    public int getRedDepth() {
        return this.redHighBit - this.redLowBit + 1;
    }

    public int getRedHighBit() {
        return this.redHighBit;
    }

    public int getRedLowBit() {
        return this.redLowBit;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getNumberOfColorComponents() {
        int result = 0;
        if (this.redMask > 0) {
            ++result;
        }
        if (this.greenMask > 0) {
            ++result;
        }
        if (this.blueMask > 0) {
            ++result;
        }
        if (this.alphaMask > 0) {
            ++result;
        }
        return result;
    }

    public int getPixelSize() {
        return (this.bitDepth + 7) / 8;
    }

    public int hashCode() {
        return this.redLowBit | this.redHighBit << 4 | this.greenLowBit << 8 | this.greenHighBit << 12 | this.blueLowBit << 16 | this.blueHighBit << 20 | this.alphaLowBit << 24 | this.alphaHighBit << 28;
    }

    public boolean equals(Object o2) {
        if (!o2.getClass().equals(this.getClass())) {
            return false;
        }
        PixelFormat pf2 = (PixelFormat)o2;
        return this.redMask == pf2.redMask && this.greenMask == pf2.greenMask && this.blueMask == pf2.blueMask && this.alphaMask == pf2.alphaMask;
    }

    public String toString() {
        return String.valueOf(this.bitDepth) + " bits";
    }
}

