/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageCache {
    private static final ImageCache imageCache = new ImageCache();
    private final ConcurrentMap<ImageDescriptor, Image> images = new ConcurrentHashMap<ImageDescriptor, Image>();
    private final ConcurrentMap<ImageDescriptor, Object> locks = new ConcurrentHashMap<ImageDescriptor, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        Image image = (Image)this.images.get(imageDescriptor);
        if (image != null) {
            return image;
        }
        Object newLock = new Object();
        Object loadLock = this.locks.putIfAbsent(imageDescriptor, newLock);
        if (loadLock == null) {
            loadLock = newLock;
        }
        Object object = loadLock;
        synchronized (object) {
            boolean returnError;
            image = (Image)this.images.get(imageDescriptor);
            if (image == null && (image = imageDescriptor.createImage(returnError = false)) != null) {
                this.images.put(imageDescriptor, image);
            }
        }
        this.locks.remove(imageDescriptor, loadLock);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Image[] imgs = null;
        ConcurrentMap<ImageDescriptor, Image> concurrentMap = this.images;
        synchronized (concurrentMap) {
            imgs = this.images.values().toArray(new Image[this.images.size()]);
            this.images.clear();
        }
        this.locks.clear();
        Image[] imageArray = imgs;
        int n = imgs.length;
        int n2 = 0;
        while (n2 < n) {
            Image img = imageArray[n2];
            img.dispose();
            ++n2;
        }
    }

    public static ImageCache getInstance() {
        return imageCache;
    }
}

