/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShowError
implements Runnable {
    private String title;
    private String message;
    private Throwable error;
    private Display display;
    private IStatus status;

    public ShowError(String title, String message, Throwable error) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = this.getDisplay();
        this.display.asyncExec((Runnable)this);
    }

    public ShowError(Display display, String title, String message, Throwable error) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = display;
        display.asyncExec((Runnable)this);
    }

    public ShowError(String title, String message, Throwable error, boolean sync) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = this.getDisplay();
        if (sync) {
            this.display.syncExec((Runnable)this);
        } else {
            this.display.asyncExec((Runnable)this);
        }
    }

    public ShowError(Display display, String title, String message, Throwable error, boolean sync) {
        this.title = title;
        this.message = message;
        this.error = error;
        this.display = display;
        if (sync) {
            display.syncExec((Runnable)this);
        } else {
            display.asyncExec((Runnable)this);
        }
    }

    public ShowError(String title, String message, IStatus status) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = this.getDisplay();
        this.display.asyncExec((Runnable)this);
    }

    public ShowError(Display display, String title, String message, IStatus status) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = display;
        display.asyncExec((Runnable)this);
    }

    public ShowError(String title, String message, IStatus status, boolean sync) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = this.getDisplay();
        if (sync) {
            this.display.syncExec((Runnable)this);
        } else {
            this.display.asyncExec((Runnable)this);
        }
    }

    public ShowError(Display display, String title, String message, IStatus status, boolean sync) {
        this.title = title;
        this.message = message;
        this.status = status;
        this.display = display;
        if (sync) {
            display.syncExec((Runnable)this);
        } else {
            display.asyncExec((Runnable)this);
        }
    }

    public Display getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        Display d = Display.getCurrent();
        if (d != null) {
            return d;
        }
        return Display.getDefault();
    }

    @Override
    public void run() {
        Shell shell = this.display.getActiveShell();
        if (this.error == null && this.status != null) {
            org.eclipse.jface.dialogs.ErrorDialog.openError((Shell)shell, (String)this.title, (String)this.message, (IStatus)this.status);
        } else {
            ErrorDialog dialog = new ErrorDialog(shell, this.title, this.message, this.error);
            dialog.open();
        }
    }

    public static void showError(String title, String message, Throwable error) {
        new ShowError(title, message, error);
    }

    public static void showError(String title, String message, IStatus status) {
        new ShowError(title, message, status);
    }

    private class ErrorDialog
    extends IconAndMessageDialog {
        private String title;
        private Text messageText;
        private Text errorText;
        private String errorString;

        protected ErrorDialog(Shell parentShell, String title, String message, Throwable error) {
            super(parentShell);
            this.title = title;
            this.message = message;
            if (error != null) {
                StringWriter sw = new StringWriter();
                error.printStackTrace(new PrintWriter(sw));
                this.errorString = sw.toString();
            }
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected Image getImage() {
            return this.getErrorImage();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.title);
            newShell.setImage(newShell.getDisplay().getSystemImage(1));
        }

        protected Control createMessageArea(Composite composite) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel = new Label(composite, 0);
                image.setBackground(this.imageLabel.getBackground());
                this.imageLabel.setImage(image);
                GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
            }
            if (this.message != null) {
                this.messageText = new Text(composite, 8391490);
                this.messageText.setEditable(false);
                this.messageText.setText(this.message);
                GridDataFactory.fillDefaults().grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageText);
            }
            return composite;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.createMessageArea(composite);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GridData childData = new GridData(1808);
            childData.horizontalSpan = 2;
            childData.grabExcessVerticalSpace = true;
            composite.setLayoutData((Object)childData);
            ErrorDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            if (this.errorString != null) {
                this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
            }
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 13) {
                if (this.errorText == null) {
                    this.errorText = new Text((Composite)this.getDialogArea(), 2816);
                    this.errorText.setText(this.errorString);
                    GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.errorText);
                } else {
                    this.errorText.dispose();
                    this.errorText = null;
                }
                this.resize();
            }
        }

        protected void resize() {
            Point size = this.getInitialSize();
            Point location = this.getInitialLocation(size);
            this.getShell().setBounds(this.getConstrainedShellBounds(new Rectangle(location.x, location.y, size.x, size.y)));
        }
    }
}

