/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InfoDialog
extends IconAndMessageDialog {
    private String title;
    private Text messageText;

    protected InfoDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(newShell.getDisplay().getSystemImage(2));
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            this.messageText = new Text(composite, 8391490);
            this.messageText.setEditable(false);
            this.messageText.setText(this.message);
            GridDataFactory.fillDefaults().grab(true, true).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageText);
        }
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.createMessageArea(composite);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        childData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)childData);
        InfoDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    public static boolean open(Shell parent, String title, String message, int style) {
        InfoDialog dialog = new InfoDialog(parent, title, message);
        dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
        return dialog.open() == 0;
    }
}

