/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.workbench.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.utils.ui.workbench.dialogs.PropertyDialog;
import org.simantics.utils.ui.workbench.dialogs.PropertyLineVerifyListener;

public class PropertyEditorDialog
extends PropertyDialog {
    public static final int ADD_PROPERTY_ID = -5000;
    public static final int REMOVE_PROPERTY_ID = -4999;
    protected Set<String> readOnlyKeys = new HashSet<String>();
    protected List<PropertyLineVerifyListener> verifyListeners = new ArrayList<PropertyLineVerifyListener>();

    public PropertyEditorDialog(Shell parent) {
        super(parent);
    }

    @Override
    protected Control createDialogArea(Composite container) {
        Control composite = super.createDialogArea(container);
        TableViewer viewer = this.getTableViewer();
        Table table = viewer.getTable();
        viewer.setInput(this.getTableViewer().getInput());
        TextCellEditor keyEditor = new TextCellEditor((Composite)table, 0);
        TextCellEditor valueEditor = new TextCellEditor((Composite)table, 0);
        ((Text)valueEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String[] sel = PropertyEditorDialog.this.getSelection();
                if (sel == null) {
                    return;
                }
                Text w = (Text)e.widget;
                String newText = w.getText();
                newText = e.text.length() == 0 ? String.valueOf(newText.substring(0, e.start)) + newText.substring(e.end, newText.length()) : String.valueOf(newText.substring(0, e.start)) + e.text + newText.substring(e.end);
                e.doit = PropertyEditorDialog.this.verifyValueModification(sel[0], newText);
            }
        });
        viewer.setCellEditors(new CellEditor[]{keyEditor, valueEditor});
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                int column = PropertyEditorDialog.this.columnNameToColumn(property);
                if (column < 0) {
                    return false;
                }
                String[] line = (String[])element;
                String key = line[0];
                boolean keyReadOnly = PropertyEditorDialog.this.isKeyReadonly(key);
                return !keyReadOnly;
            }

            public Object getValue(Object element, String property) {
                int column = PropertyEditorDialog.this.columnNameToColumn(property);
                String[] line = (String[])element;
                return line[column];
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    element = ((TableItem)element).getData();
                }
                int column = PropertyEditorDialog.this.columnNameToColumn(property);
                String[] line = (String[])element;
                String key = line[0];
                if (column == 0 && PropertyEditorDialog.this.containsKey(value.toString())) {
                    return;
                }
                if (column == 0 && PropertyEditorDialog.this.isKeyReadonly(key)) {
                    return;
                }
                if (column == 0 && !PropertyEditorDialog.this.verifyValueModification(value.toString(), line[1])) {
                    return;
                }
                line[column] = value.toString();
                PropertyEditorDialog.this.labelProvider.elementChanged(new Object[]{element});
            }
        });
        return composite;
    }

    protected boolean containsKey(String key) {
        for (String[] line : this.data) {
            if (!line[0].equals(key)) continue;
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -5000, "Add property", false);
        this.createButton(parent, -4999, "Remove property", false);
        this.setAddCancelButton(true);
        super.createButtonsForButtonBar(parent);
        this.setAddCancelButton(false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == -5000) {
            this.addPropertyPressed();
        } else if (buttonId == -4999) {
            this.removePropertyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected String[] getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.getTableViewer().getSelection();
        if (sel == null) {
            return null;
        }
        Object o = sel.getFirstElement();
        if (o == null) {
            return null;
        }
        return (String[])o;
    }

    private void removePropertyPressed() {
        String[] o = this.getSelection();
        if (o == null) {
            return;
        }
        if (this.readOnlyKeys.contains(o[0])) {
            return;
        }
        if (!this.data.remove(o)) {
            return;
        }
        this.labelProvider.refreshAll();
    }

    private void addPropertyPressed() {
        Object[] newElement = new String[]{"<new property>", "<value>"};
        this.data.add(newElement);
        this.labelProvider.refreshAll();
        this.getTableViewer().setSelection((ISelection)new StructuredSelection(newElement));
    }

    public void setReadOnlyFields(String[] readOnlyFields) {
        String[] stringArray = readOnlyFields;
        int n = readOnlyFields.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.readOnlyKeys.add(key);
            ++n2;
        }
    }

    public void setFieldReadOnlyStatus(String key, boolean readOnly) {
        if (readOnly) {
            this.readOnlyKeys.add(key);
        } else {
            this.readOnlyKeys.remove(key);
        }
    }

    protected boolean isKeyReadonly(String key) {
        return this.readOnlyKeys.contains(key);
    }

    public List<String[]> getData() {
        return this.data;
    }

    public void addVerifyListener(PropertyLineVerifyListener listener) {
        this.verifyListeners.add(listener);
    }

    public void removeVerifyListener(PropertyLineVerifyListener listener) {
        this.verifyListeners.remove(listener);
    }

    protected boolean verifyValueModification(String key, String value) {
        boolean result = true;
        for (PropertyLineVerifyListener l : this.verifyListeners) {
            result &= l.verifyValue(key, value);
        }
        return result;
    }
}

