/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.threads.ua;

import java.util.Collection;

/**
 * Worker executes tasks. 
 * <p>
 * Hint! To execute work synchronously use: <BR>
 *  Worker.asyncExec(runnable, null).waitForState(WorkState.FINAL_STATES);
 * <p>
 * To cancel all work get the work with getQueuedWork() and invoke cancel() to each.
 * 
 * @see SynchronizedWorker
 * @see ThreadPool
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface Worker extends StatefulExecutor {
	
	/**
	 * Execute work (async).
	 * 
	 * @param runnable
	 * @param initialListener listener initially set on monitor object or null
	 * @return async work monitor object
	 */
	WorkMonitor asyncExec(Runnable runnable, StateListener<WorkState> initialListener)
	throws WorkerClosedException;

	/**
	 * Get a list of all queued work.
	 * @param result queued work.
	 */
	void getQueuedWork(Collection<WorkMonitor> result);

}
