/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.context;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SyncListenerList;
import org.simantics.utils.threads.ThreadUtils;

public class Context<E>
extends AbstractDisposable
implements IContext<E> {
    protected Set<E> set = new HashSet();
    protected SyncListenerList<IContextListener> listeners = new SyncListenerList(IContextListener.class);
    final Class<E> clazz;
    private E[] snapshotArray;
    private Map<Class<? extends E>, Collection<? extends E>> classQueryResultCache = new HashMap<Class<? extends E>, Collection<? extends E>>();
    private static Method itemAdded = SyncListenerList.getMethod(IContextListener.class, (String)"itemAdded");
    private static Method itemRemoved = SyncListenerList.getMethod(IContextListener.class, (String)"itemRemoved");

    public Context(Class<E> clazz) {
        this.clazz = clazz;
        this.snapshotArray = this.createArray(clazz, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(E item) {
        Executable[] executables;
        this.assertNotDisposed();
        Context context = this;
        synchronized (context) {
            if (this.set.contains(item)) {
                throw new IllegalArgumentException("Context already contains item " + item);
            }
            this.set.add(item);
            this.snapshotArray = this.createSnapshot(this.set);
            executables = this.listeners.getExecutables(itemAdded, new Object[]{this, item});
            Iterator<Class<E>> i = this.classQueryResultCache.keySet().iterator();
            while (i.hasNext()) {
                Class<E> c = i.next();
                if (!c.isInstance(item)) continue;
                i.remove();
            }
        }
        ThreadUtils.multiSyncExec((Executable[])executables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(E item) {
        Executable[] executables;
        this.assertNotDisposed();
        Context context = this;
        synchronized (context) {
            block5: {
                if (this.set.remove(item)) break block5;
                return false;
            }
            this.snapshotArray = this.createSnapshot(this.set);
            executables = this.listeners.getExecutables(itemRemoved, new Object[]{this, item});
            Iterator<Class<E>> i = this.classQueryResultCache.keySet().iterator();
            while (i.hasNext()) {
                Class<E> c = i.next();
                if (!c.isInstance(item)) continue;
                i.remove();
            }
        }
        ThreadUtils.multiSyncExec((Executable[])executables);
        return true;
    }

    @Override
    public synchronized boolean contains(E item) {
        this.assertNotDisposed();
        return this.set.contains(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.assertNotDisposed();
        this.classQueryResultCache.clear();
        ArrayList executables = new ArrayList();
        Context context = this;
        synchronized (context) {
            if (this.set.isEmpty()) {
                return;
            }
            E[] EArray = this.snapshotArray;
            int n = this.snapshotArray.length;
            int n2 = 0;
            while (n2 < n) {
                E item = EArray[n2];
                this.listeners.addExecutables(executables, itemRemoved, new Object[]{this, item});
                ++n2;
            }
            this.set.clear();
            this.snapshotArray = this.createSnapshot(this.set);
        }
        ThreadUtils.multiSyncExec(executables);
    }

    @Override
    public synchronized <R extends E> Collection<R> getItemsByClass(Class<R> clazz) {
        this.assertNotDisposed();
        Collection<E> result = this.classQueryResultCache.get(clazz);
        if (result != null) {
            return result;
        }
        result = new ArrayList<E>();
        for (E i : this.set) {
            if (!clazz.isAssignableFrom(i.getClass())) continue;
            result.add(i);
        }
        this.classQueryResultCache.put(clazz, result);
        return result;
    }

    @Override
    public synchronized <R> boolean containsItemByClass(Class<R> clazz) {
        this.assertNotDisposed();
        Collection<E> result = this.classQueryResultCache.get(clazz);
        if (result != null) {
            return !result.isEmpty();
        }
        for (E i : this.set) {
            if (!clazz.isAssignableFrom(i.getClass())) continue;
            return true;
        }
        return false;
    }

    private <R extends E> R[] createArray(Class<R> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }

    E[] createSnapshot(Set<E> set) {
        E[] result = this.createArray(this.clazz, set.size());
        int index = 0;
        for (E i : set) {
            result[index++] = i;
        }
        return result;
    }

    @Override
    public synchronized <R extends E> R getSingleItem(Class<R> clazz) {
        this.assertNotDisposed();
        Collection<R> result = this.getItemsByClass(clazz);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        throw new RuntimeException("one " + clazz.getName() + " expected in Context, got " + result.size());
    }

    @Override
    public E[] toArray() {
        this.assertNotDisposed();
        return this.snapshotArray;
    }

    @Override
    public void addContextListener(IContextListener<E> listener) {
        this.assertNotDisposed();
        this.listeners.add(listener);
    }

    @Override
    public void removeContextListener(IContextListener<E> listener) {
        this.assertNotDisposed();
        this.listeners.remove(listener);
    }

    @Override
    public void addContextListener(IThreadWorkQueue thread, IContextListener<E> listener) {
        this.assertNotDisposed();
        this.listeners.add(thread, listener);
    }

    @Override
    public void removeContextListener(IThreadWorkQueue thread, IContextListener<E> listener) {
        this.assertNotDisposed();
        this.listeners.remove(thread, listener);
    }

    @Override
    public <R extends E> R getAtMostOneItemOfClass(Class<R> clazz) {
        this.assertNotDisposed();
        int count = 0;
        R r = null;
        for (E i : this.set) {
            if (!clazz.isAssignableFrom(i.getClass())) continue;
            ++count;
            r = (R)i;
        }
        if (count == 0) {
            return null;
        }
        if (count > 1) {
            throw new RuntimeException("one " + clazz.getName() + " expected in Context, got " + count);
        }
        return r;
    }

    @Override
    protected void doDispose() {
    }

    public String toString() {
        String s = EString.implode((Object[])this.snapshotArray, (String)"\n");
        return s != null ? s : "";
    }
}

