/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.cache;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.utils.datastructures.cache.ITimedCache;
import org.simantics.utils.threads.ThreadUtils;

public class SoftTimedCache<K, V>
implements ITimedCache<K, V> {
    private final Map<K, Entry> cache = Collections.synchronizedMap(new HashMap());
    private String name;
    private Timer timer;

    public SoftTimedCache() {
        this("Cache Timer");
    }

    public SoftTimedCache(String name) {
        this.name = name;
    }

    public int size() {
        return this.cache.size();
    }

    protected void finalize() throws Throwable {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.clear();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Object[] entries;
        SoftTimedCache softTimedCache = this;
        synchronized (softTimedCache) {
            entries = this.cache.values().toArray();
            this.cache.clear();
        }
        Object[] objectArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Entry e = (Entry)o;
            Object v = e.ref.get();
            e.ref.clear();
            this.cleanup(e);
            this.disposeValue(v);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K k, V v, long holdTime, TimeUnit unit) {
        Entry e = new Entry(k, v, holdTime, unit);
        SoftTimedCache softTimedCache = this;
        synchronized (softTimedCache) {
            this.dispose(k);
            this.cache.put(k, e);
            if (unit != null && holdTime > 0L) {
                this.schedule(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V release(K k) {
        Entry e;
        SoftTimedCache softTimedCache = this;
        synchronized (softTimedCache) {
            e = this.cache.remove(k);
        }
        if (e == null) {
            return null;
        }
        return this.cleanup(e);
    }

    private V cleanup(Entry e) {
        boolean ret;
        if (e.future != null && !e.future.isCancelled() && !(ret = e.future.cancel(false))) {
            return null;
        }
        return e.ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(K k) {
        Entry e;
        SoftTimedCache softTimedCache = this;
        synchronized (softTimedCache) {
            e = this.cache.remove(k);
        }
        if (e == null) {
            return;
        }
        Object v = e.ref.get();
        if (v != null) {
            if (e.future != null) {
                e.future.cancel(false);
            }
            e.ref.clear();
            this.disposeValue(v);
        }
    }

    void schedule(final Entry e) {
        e.future = ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        SoftTimedCache.this.dispose(e.key);
                    }
                });
            }
        }, e.holdTime, e.unit);
    }

    protected void disposeValue(V v) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheEntry> getEntries() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        SoftTimedCache softTimedCache = this;
        synchronized (softTimedCache) {
            for (Entry e : this.cache.values()) {
                result.add(new CacheEntry(e));
            }
        }
        return result;
    }

    public class CacheEntry {
        private final Entry e;
        private final V value;

        public CacheEntry(Entry e) {
            this.e = e;
            this.value = e.ref.get();
        }

        public K getKey() {
            return this.e.key;
        }

        public V getValue() {
            return this.value;
        }

        public boolean disposeScheduled() {
            return this.e.future != null;
        }

        public void schedule(long holdTime, TimeUnit unit) {
            if (this.e.future == null) {
                this.e.holdTime = holdTime;
                this.e.unit = unit;
                SoftTimedCache.this.schedule(this.e);
            }
        }
    }

    protected class Entry {
        final K key;
        final SoftReference<V> ref;
        long holdTime;
        TimeUnit unit;
        ScheduledFuture<?> future;

        Entry(K k, V v, long holdTime, TimeUnit unit) {
            assert (k != null);
            assert (v != null);
            this.key = k;
            this.ref = new SoftReference(v);
            this.holdTime = holdTime;
            this.unit = unit;
        }
    }
}

