/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public final class TimingUtil {
    public static void time(Runnable runnable) {
        TimingUtil.time(runnable, System.out);
    }

    public static void time(Runnable runnable, PrintStream stream) {
        TimingUtil.time(runnable, TimeUnit.MILLISECONDS, new PrintCallback(runnable.toString(), stream));
    }

    public static void time(Runnable runnable, TimeUnit reportTimeUnit, PrintStream stream) {
        TimingUtil.time(runnable, reportTimeUnit, new PrintCallback(runnable.toString(), stream));
    }

    public static void time(Runnable runnable, TimeUnit reportTimeUnit, BiConsumer<Long, TimeUnit> result) {
        long start = System.nanoTime();
        runnable.run();
        long end = System.nanoTime();
        result.accept(reportTimeUnit.convert(end - start, TimeUnit.NANOSECONDS), reportTimeUnit);
    }

    public static abstract class NamedRunnable
    implements Runnable {
        String name;

        public NamedRunnable(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PrintCallback
    implements BiConsumer<Long, TimeUnit> {
        String task;
        PrintStream stream;

        PrintCallback(String task) {
            this(task, System.out);
        }

        PrintCallback(String task, PrintStream stream) {
            this.task = task;
            this.stream = stream;
        }

        @Override
        public void accept(Long arg1, TimeUnit arg2) {
            this.stream.println(String.valueOf(this.task) + " took " + arg1 + " " + arg2.toString());
        }
    }
}

