/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.internal;

/**
 * @author Toni Kalajainen
 */
public class ObjectUtils {

    /**
     * Compares two object for equality.
     * <p>
     * Some times it is annoying to compare two objects if their value may be
     * null.
     * 
     * @param o1 obj1
     * @param o2 obj2
     * @return true if equal or both null
     */
    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2)
            return true;
        if (o1 == null && o2 == null)
            return true;
        if (o1 == null || o2 == null)
            return false;
        return o1.equals(o2);
    }

}
