/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.cache;

import java.lang.ref.SoftReference;

/**
 * Caches the value provided by provider until the value has been garbage collected.
 * <p>
 * Cached IProvider provides the same instance as long as it is in memory.
 * <p>
 * Cached version is equal to original in hashCode/equals wise.
 * 
 * @author Toni Kalajainen
 */
public class SoftCachedProvider<V> implements IProvider<V> {

    public static final <V> IProvider<V> cache(IProvider<V> provider)
    {
        if (provider instanceof SoftCachedProvider<?>)
            return provider;
        return new SoftCachedProvider<V>(provider);
    }

    IProvider<V> provider;
    SoftReference<V> ref;

    SoftCachedProvider(IProvider<V> orig)
    {
        this.provider = orig;
    }

    @Override
    public synchronized V get() throws ProvisionException {
        if (ref!=null) {
            V x = ref.get();
            if (x==null) ref=null;
            else return x;
        }
        V x = provider.get();
        ref = new SoftReference<V>(x);
        return x;
    }

    @Override
    public int hashCode() {
        return provider.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return provider.equals(obj);
    }

}
