/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.cache;

/**
 * Interface used for lazy initialization.
 * 
 * 
 * @see StaticProvider static provider (provides the same instance always)
 * @author Toni Kalajainen
 */
public interface IProvider<V> {

    /**
     * Provides a value on demand. 
     * 
     * @return the value (may not be null)
     */
    V get()
    throws ProvisionException;
    
}