/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

/**
 * A generic Triple (3-tuple) structure for containing three object instances of
 * chosen types.
 * 
 * @param <T1> type of first element
 * @param <T2> type of second element
 * @param <T3> type of third element
 */
public final class Triple<T1, T2, T3> {
    public final T1 first;
    public final T2 second;
    public final T3 third;
    private final int hash;

    public static <T1, T2, T3> Triple<T1, T2, T3> make(T1 t1, T2 t2, T3 t3) {
        return new Triple<T1, T2, T3>(t1, t2, t3);
    }

    public Triple(T1 first, T2 second, T3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.hash = makeHash();
    }
    
    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj.getClass().equals(this.getClass())))
            return false;
        Triple<?, ?, ?> other = (Triple<?, ?, ?>) obj;
        if (other.first != first && (other.first == null || !other.first.equals(first)))
            return false;
        if (other.second != second && (other.second == null || !other.second.equals(second)))
            return false;
        if (other.third != third && (other.third == null || !other.third.equals(third)))
            return false;
        return true;
    }
    
    @Override
    public int hashCode() {
        return hash;
    }
    
    @Override
    public String toString() {
        return "<"+first+", "+second+", "+third+">";
    }
    
    private int makeHash() {
        return (first == null ? 0 : first.hashCode()) + (second == null ? 0 : second.hashCode())*31 + (third == null ? 0 : third.hashCode())*41;
    }
}
