/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class ListAdapter<Domain,Range,C extends List<Domain>> 
    extends CollectionAdapter<Domain,Range,C>
    implements List<Range> {

    public ListAdapter(Converter<Domain,Range> converter, C collection) {
        super(converter, collection);
    }
    
    @Override
    public void add(int index, Range element) {
        collection.add(index, converter.convertFrom(element));        
    }

    @SuppressWarnings("unchecked")
    @Override
    public boolean addAll(int index, Collection<? extends Range> c) {
        return collection.addAll(index, new CollectionAdapter<Range, Domain, Collection<Range>>(inverseConverter(converter), (Collection<Range>)c));
    }

    @Override
    public Range get(int index) {
        return converter.convertTo(collection.get(index));        
    }

    @SuppressWarnings("unchecked")
    @Override
    public int indexOf(Object o) {
        return collection.indexOf(converter.convertFrom((Range)o));
    }

    @SuppressWarnings("unchecked")
    @Override
    public int lastIndexOf(Object o) {
        return collection.lastIndexOf(converter.convertFrom((Range)o));
    }
    
    @Override
    public ListIterator<Range> listIterator() {
        return new ListIteratorAdapter<Domain, Range, ListIterator<Domain>>
            (converter, collection.listIterator());
    }

    @Override
    public ListIterator<Range> listIterator(int index) {
        return new ListIteratorAdapter<Domain, Range, ListIterator<Domain>>
            (converter, collection.listIterator(index));                
    }

    @Override
    public Range remove(int index) {
        return converter.convertTo(collection.remove(index));
    }

    @Override
    public Range set(int index, Range element) {
        return converter.convertTo(collection.set(index, converter.convertFrom(element)));
    }

    @Override
    public List<Range> subList(int fromIndex, int toIndex) {
        return new ListAdapter<Domain,Range,List<Domain>>(converter, collection.subList(fromIndex, toIndex)); 
    }    

}
