/*******************************************************************************
 * Copyright (c) 2007, 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Map;

/**
 * A common {@link Entry} implementation for both {@link ArrayMap}
 * and {@link InterlacedArrayMap}.
 * 
 * @author Tuukka Lehtonen
 *
 * @param <K> key class
 * @param <V> value class
 */
class ArrayMapEntry<K, V> implements Map.Entry<K, V> {
    final K key;
    V value;

    /**
     * Creates new entry.
     */
    ArrayMapEntry(int h, K k, V v) {
        value = v;
        key = k;
    }

    @Override
    public final K getKey() {
        return key;
    }

    @Override
    public final V getValue() {
        return value;
    }

    @Override
    public final V setValue(V newValue) {
        V oldValue = value;
        value = newValue;
        return oldValue;
    }

    @Override
    public final boolean equals(Object o) {
        if (!(o instanceof Map.Entry<?, ?>))
            return false;
        Map.Entry<?, ?> e = (Map.Entry<?, ?>)o;
        Object k1 = getKey();
        Object k2 = e.getKey();
        if (k1 == k2 || (k1 != null && k1.equals(k2))) {
            Object v1 = getValue();
            Object v2 = e.getValue();
            if (v1 == v2 || (v1 != null && v1.equals(v2)))
                return true;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return (key==null   ? 0 : key.hashCode()) ^
        (value==null ? 0 : value.hashCode());
    }

    @Override
    public final String toString() {
        return getKey() + "=" + getValue();
    }
}