/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.dialogs;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.ui.gfx.CompositionImageDescriptor;

public class ResourceLabelProvider
implements ILabelProvider {
    protected List<ILabelProviderListener> listeners = null;
    protected IThreadWorkQueue thread;
    protected TaskRepository tasks;
    protected LoadJob loadJob;

    public ResourceLabelProvider(Display display) {
        this.thread = SWTThread.getThreadAccess((Display)display);
        this.tasks = new TaskRepository((Device)display);
        this.loadJob = new LoadJob("Resource Labeler", this.tasks, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangedEvent(LabelProviderChangedEvent e) {
        ILabelProviderListener[] listeners;
        ResourceLabelProvider resourceLabelProvider = this;
        synchronized (resourceLabelProvider) {
            if (this.listeners == null) {
                return;
            }
            listeners = this.listeners.toArray(new ILabelProviderListener[0]);
        }
        ILabelProviderListener[] iLabelProviderListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProviderListener l = iLabelProviderListenerArray[n2];
            l.labelProviderChanged(e);
            ++n2;
        }
    }

    public void asyncFireChangedEvent(final LabelProviderChangedEvent e) {
        this.thread.asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceLabelProvider.this.fireChangedEvent(e);
            }
        });
    }

    public synchronized void addListener(ILabelProviderListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<ILabelProviderListener>();
        }
        this.listeners.add(listener);
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.loadJob.dispose();
        this.tasks.dispose();
    }

    public void clear() {
        this.tasks.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        System.out.println("isLabelProperty(" + element + ", " + property + ")");
        return false;
    }

    public synchronized void removeListener(ILabelProviderListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        Resource r = (Resource)element;
        Task task = this.tasks.getCompleted(r);
        if (task != null) {
            return task.image;
        }
        task = this.tasks.queue(r);
        this.loadJob.scheduleIfNecessary(100L);
        return task.image;
    }

    public String getText(Object element) {
        if (element == null) {
            return null;
        }
        Resource r = (Resource)element;
        Task task = this.tasks.getCompleted(r);
        if (task != null) {
            return task.label;
        }
        task = this.tasks.queue(r);
        this.loadJob.scheduleIfNecessary(100L);
        return task.label;
    }

    private static class LoadJob
    extends DatabaseJob {
        private TaskRepository tasks;
        private ResourceLabelProvider labelProvider;
        private AtomicBoolean isScheduled = new AtomicBoolean();

        public LoadJob(String name, TaskRepository tasks, ResourceLabelProvider labelProvider) {
            super(name);
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(20);
            this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
            this.tasks = tasks;
            this.labelProvider = labelProvider;
        }

        public boolean scheduleIfNecessary(long delay) {
            if (this.isScheduled.compareAndSet(false, true)) {
                this.schedule(delay);
                return true;
            }
            return false;
        }

        void dispose() {
            this.tasks = null;
            this.labelProvider = null;
        }

        public boolean shouldSchedule() {
            return this.tasks != null;
        }

        public boolean shouldRun() {
            return this.tasks != null;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.isScheduled.set(false);
                TaskRepository tr = this.tasks;
                if (tr == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                Task[] taskList = tr.pruneTasks();
                IStatus iStatus = this.runTasks(tr, taskList);
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private IStatus runTasks(final TaskRepository tr, final Task[] taskList) {
            Session session = Simantics.peekSession();
            if (session == null) {
                return Status.CANCEL_STATUS;
            }
            final ResourceManager rm = tr.resourceManager;
            if (rm == null) {
                return Status.CANCEL_STATUS;
            }
            final MultiStatus result = new MultiStatus("org.simantics.ui", 0, "Problems encountered while invoking resource label provider:", null);
            try {
                Simantics.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        Task[] taskArray = taskList;
                        int n = taskList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Task task = taskArray[n2];
                            try {
                                if (tr.isDisposed()) {
                                    return;
                                }
                                this.runTask(rm, graph, task);
                                tasks.complete(task);
                            }
                            catch (DatabaseException e) {
                                result.add((IStatus)new Status(4, "org.simantics.ui", e.getMessage(), (Throwable)e));
                            }
                            ++n2;
                        }
                    }
                });
                MultiStatus multiStatus = result;
                return multiStatus;
            }
            catch (DatabaseException e) {
                Status status = new Status(4, "org.simantics.ui", "Resource label provider failed unexpectedly.", (Throwable)e);
                return status;
            }
            finally {
                this.labelProvider.asyncFireChangedEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this.labelProvider));
            }
        }

        protected void runTask(ResourceManager rm, ReadGraph graph, Task task) throws DatabaseException {
            task.label = this.getText(graph, task.resource);
            task.image = this.getImage(rm, graph, task.resource);
        }

        protected String getText(ReadGraph graph, Resource resource) {
            try {
                return (String)graph.adapt(resource, String.class);
            }
            catch (DatabaseException databaseException) {
                try {
                    return NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
                }
                catch (DatabaseException databaseException2) {
                    return "";
                }
            }
        }

        public Image getImage(ResourceManager rm, ReadGraph graph, Resource resource) throws DatabaseException {
            ImageDescriptor i = this.getImageDescriptor(graph, resource, new ImageDescriptor[0]);
            return i == null ? null : (Image)rm.get((DeviceResourceDescriptor)i);
        }

        public ImageDescriptor getImageDescriptor(ReadGraph graph, Resource resource, ImageDescriptor ... decorations) throws DatabaseException {
            ImageDescriptor baseImage = ImageUtil.adaptImageDescriptor(graph, resource);
            if (baseImage == null) {
                return null;
            }
            if (decorations == null || decorations.length == 0) {
                return baseImage;
            }
            ArrayList<ImageDescriptor> images = new ArrayList<ImageDescriptor>(1 + decorations.length);
            images.add(baseImage);
            ImageDescriptor[] imageDescriptorArray = decorations;
            int n = decorations.length;
            int n2 = 0;
            while (n2 < n) {
                ImageDescriptor image = imageDescriptorArray[n2];
                images.add(image);
                ++n2;
            }
            return CompositionImageDescriptor.compose(images);
        }
    }

    private static class Task {
        public static final Task[] NONE = new Task[0];
        public final Resource resource;
        public String label = "";
        public Image image;

        public Task(Resource resource) {
            this.resource = resource;
        }
    }

    private static class TaskRepository {
        Map<Resource, Task> tasks = new THashMap();
        Map<Resource, Task> completed = new THashMap();
        ResourceManager resourceManager;

        public TaskRepository(Device device) {
            this.resourceManager = new DeviceResourceManager(device);
        }

        public boolean isDisposed() {
            return this.resourceManager == null;
        }

        public void dispose() {
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task queue(Task task) {
            Map<Resource, Task> map = this.tasks;
            synchronized (map) {
                this.tasks.put(task.resource, task);
            }
            return task;
        }

        public Task queue(Resource resource) {
            return this.queue(new Task(resource));
        }

        public void clear() {
            this.pruneTasks();
            this.pruneCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task[] pruneTasks() {
            Map<Resource, Task> map = this.tasks;
            synchronized (map) {
                Task[] result = this.tasks.values().toArray(Task.NONE);
                this.tasks.clear();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pruneCompleted() {
            Map<Resource, Task> map = this.completed;
            synchronized (map) {
                this.completed.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(Task task) {
            Map<Resource, Task> map = this.completed;
            synchronized (map) {
                this.completed.put(task.resource, task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task getCompleted(Resource r) {
            Map<Resource, Task> map = this.completed;
            synchronized (map) {
                return this.completed.get(r);
            }
        }
    }
}

