/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.auth;

import java.io.IOException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.management.discovery.ServerInfo;
import org.simantics.db.service.ServerInformation;
import org.simantics.ui.auth.LoginDialog;
import org.simantics.ui.auth.model.LoginModel;
import org.simantics.ui.internal.Activator;
import org.simantics.utils.ui.ExceptionUtils;

public class AuthenticationUtils {
    public static LoginModel queryAuthenticationInfo(Shell parentShell, ServerInfo forServer, boolean forceQuery) {
        LoginDialog dialog;
        boolean remember;
        LoginModel model = AuthenticationUtils.loadAuthenticationInfo(forServer);
        if (model == null) {
            model = new LoginModel(forServer);
        }
        if ((remember = model.isRemember()) && model.getName().trim().isEmpty()) {
            remember = false;
        }
        if ((!remember || forceQuery) && (dialog = new LoginDialog(parentShell, Activator.getDefault().getDialogSettings(), model)).open() != 0) {
            return null;
        }
        return model;
    }

    private static LoginModel loadAuthenticationInfo(ServerInfo forServer) {
        ISecurePreferences preferences;
        String id;
        block4: {
            ServerInformation info = forServer.getInfo();
            if (info == null) {
                return null;
            }
            id = AuthenticationUtils.formId(info);
            try {
                preferences = SecurePreferencesFactory.getDefault().node("procore");
                if (preferences.nodeExists(id)) break block4;
                return null;
            }
            catch (StorageException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
                return null;
            }
        }
        ISecurePreferences server = preferences.node(id);
        String name = server.get("name", "");
        String pass = server.get("pass", "");
        return new LoginModel(forServer, name, pass, true, true);
    }

    public static void storeAuthenticationInfo(ServerInfo forServer, LoginModel model) throws IOException {
        ServerInformation info = forServer.getInfo();
        if (info == null) {
            throw new IllegalArgumentException("server information not available for uniquely identifying the server");
        }
        String id = AuthenticationUtils.formId(info);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault().node("procore");
        ISecurePreferences server = preferences.node(id);
        try {
            server.put("name", model.getName(), false);
            server.put("pass", model.getPassword(), true);
            server.flush();
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    private static String formId(ServerInformation info) {
        return info.getDatabaseId();
    }
}

