/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workspace.tracker.internal.contributions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.simantics.filesystem.services.sizetracker.DirectorySizeService;
import org.simantics.filesystem.services.sizetracker.SizeTracker;
import org.simantics.ui.workspace.tracker.internal.Activator;
import org.simantics.ui.workspace.tracker.internal.contributions.WorkspaceSizeTrackerTrim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceSizeTrackerContribution {
    private Logger logger = LoggerFactory.getLogger(WorkspaceSizeTrackerContribution.class);
    private SizeTracker workspaceSizeTracker;

    @PostConstruct
    void createControls(Composite parent, MToolControl toolControl) {
        String trackSize = System.getProperty("org.simantics.filesystem.services.sizeTracker", null);
        if (trackSize != null && trackSize.equalsIgnoreCase("false")) {
            return;
        }
        Path ws = WorkspaceSizeTrackerContribution.getWorkspacePath();
        if (ws != null && !Files.isDirectory(ws, new LinkOption[0])) {
            return;
        }
        DirectorySizeService dss = Activator.getDefault().getDirectorySizeService();
        if (dss == null) {
            return;
        }
        try {
            this.workspaceSizeTracker = dss.track(ws);
            new WorkspaceSizeTrackerTrim(parent, toolControl, this.workspaceSizeTracker, Activator.getDefault().getPreferenceStore());
        }
        catch (IOException e) {
            this.logger.error("Failed to start workspace size tracking for {}", (Object)ws, (Object)e);
        }
    }

    @PreDestroy
    void dispose() {
        try {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    SizeTracker t = this.workspaceSizeTracker;
                    if (t != null) {
                        t.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to shutdown workspace size tracking for {}", (Object)this.workspaceSizeTracker, (Object)e);
                this.workspaceSizeTracker = null;
            }
        }
        finally {
            this.workspaceSizeTracker = null;
        }
    }

    private static Path getWorkspacePath() {
        IPath ip = Platform.getLocation();
        return ip != null ? ip.toFile().toPath() : null;
    }

    public static void showTracker(boolean show) {
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        if (context == null) {
            return;
        }
        EModelService modelService = (EModelService)context.get(EModelService.class);
        MApplication app = (MApplication)context.get(MApplication.class);
        if (modelService == null || app == null) {
            return;
        }
        MUIElement element = modelService.find("org.simantics.ui.workspace.tracker.toolcontrol.0", (MUIElement)app);
        if (element != null && element.isToBeRendered() != show) {
            element.setToBeRendered(show);
            Object widget = element.getWidget();
            if (widget instanceof Control) {
                ((Control)widget).getShell().layout(null, 7);
            }
        }
    }
}

