package org.simantics.ui.workbench.action;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Session;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public final class DefaultActions {

    /**
     * Perform a default workbench action on the specified input object using
     * {@link ChooseActionRequest} from any thread asynchronously.
     * 
     * @param session
     * @param input
     * @param rememberAction
     * @param alwaysAsk
     * @param neverPromptForAction true to never prompt/run an action if the
     *        action selection is ambiguous
     */
    public static void asyncPerformDefaultAction(
            final Session session,
            final Object input,
            final boolean rememberAction,
            final boolean alwaysAsk,
            final boolean neverPromptForAction)
    {
        SWTUtils.asyncExec(PlatformUI.getWorkbench().getDisplay(), new Runnable() {
            @Override
            public void run() {
                performDefaultAction(session, input, rememberAction, alwaysAsk, neverPromptForAction);
            }
        });
    }

    /**
     * Perform a default workbench action on the specified input object using
     * {@link ChooseActionRequest} from the current thread. The current thread
     * must be the SWT UI thread.
     * 
     * @param session
     * @param input
     * @param rememberAction
     * @param alwaysAsk
     * @param neverPromptForAction true to never prompt/run an action if the
     *        action selection is ambiguous
     */
    public static void performDefaultAction(
            final Session session,
            final Object input,
            boolean rememberAction,
            boolean alwaysAsk,
            boolean neverPromptForAction)
    {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window != null ? window.getShell() : null;
        session.asyncRequest(new ChooseActionRequest(shell, null, input, WorkbenchUtils.getCurrentPerspectiveId(), rememberAction, alwaysAsk, neverPromptForAction));
    }

    /**
     * Perform a default workbench action on the specified input object using
     * {@link ChooseActionRequest} from the current thread. The current thread
     * must be the SWT UI thread.
     * 
     * @param control the control contained
     */
    public static void performDefaultAction(Control control, Object input) {
        new PerformDefaultAction("Perform Default Action", control, input).run();
    }

}
