/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.ui.dnd;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;

/**
 * An SWT drag source listener that provides the specified selection provider's
 * {@link ISelection} as the dragged data to {@link DropTargetListener}s.
 * 
 * <p>
 * Only guaranteed to work with {@link LocalObjectTransfer} which will only work
 * within a single application.
 * 
 * @author Tuukka Lehtonen
 */
public class LocalSelectionDragSourceListener implements DragSourceListener {

    ISelectionProvider selectionProvider;
    ISelection         selection;

    public LocalSelectionDragSourceListener(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public ISelection getSelection() {
        return selection;
    }

    @Override
    public void dragFinished(DragSourceEvent event) {
        //System.out.println("SOURCE FINISH " + event);
        LocalObjectTransfer.getTransfer().clear();
        selection = null;
    }

    @Override
    public void dragSetData(DragSourceEvent event) {
        //System.out.println("SOURCE PUT " + event + " " + selection);
        event.data = selection;
        LocalObjectTransfer.getTransfer().setObject(selection);
        
    }

    @Override
    public void dragStart(DragSourceEvent event) {
        //System.out.println("SOURCE START " + event + " " + selectionProvider.getSelection());
        selection = selectionProvider.getSelection();
        if (selection == null || selection.isEmpty())
            event.doit = false;
        else {
            event.doit = true;
            LocalObjectTransfer.getTransfer().setObject(selection);
        }
    }

}
