/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.history.HistoryManager;
import org.simantics.trend.TrendInitializer;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.configuration.Viewport;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.TrendNode;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.threads.AWTThread;

public class PrintUtil {
    PageDesc pageDesc;
    FontMapper mapper;
    List<PrintPage> pages = new ArrayList<PrintPage>();

    public PrintUtil() {
        this.pageDesc = new PageDesc("A4", PageOrientation.Landscape, 210.0, 297.0).withMargins(MarginUtils.MARGINS_10mm);
        this.mapper = new DefaultFontMapper();
        FontFactory.registerDirectories();
    }

    public void addTrendPage(TrendSpec trendSpec, HistoryManager historian, MilestoneSpec milestones, Viewport viewport) {
        this.pages.add(TrendPage.addTrendPage(trendSpec, historian, milestones, viewport));
    }

    public void addTrendPage(TrendNode srcTrend) {
        this.pages.add(TrendPage.createFrom(srcTrend));
    }

    public void setPageDesc(PageDesc pageDesc) {
        this.pageDesc = pageDesc;
    }

    public void print() throws PrinterException {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                if (!(graphics instanceof Graphics2D)) {
                    throw new PrinterException("Printer context does not support Graphics2D");
                }
                if (pageIndex < PrintUtil.this.pages.size()) {
                    Graphics2D g2d = (Graphics2D)graphics;
                    g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                    Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
                    System.out.println("Printing page " + pageIndex + ", pageFormat=" + pageFormat.getImageableX() + ", " + pageFormat.getImageableY() + ", " + pageFormat.getImageableWidth() + ", " + pageFormat.getImageableHeight());
                    PrintPage trend = PrintUtil.this.pages.get(pageIndex);
                    trend.print(g2d, rect);
                    return 0;
                }
                return 1;
            }
        });
        printJob.printDialog();
        printJob.print();
    }

    public void printPdf(File file) throws IOException {
        Document document = null;
        FileOutputStream fos = null;
        Graphics g2 = null;
        try {
            PdfWriter writer;
            Rectangle2D.Float pageArea = new Rectangle2D.Float();
            this.pageDesc.getPageRectangle((Rectangle2D)pageArea);
            Rectangle2D.Float contentArea = new Rectangle2D.Float();
            this.pageDesc.getMarginsRectangle((Rectangle2D)contentArea);
            Rectangle pageArea2 = new Rectangle((float)PageDesc.toPoints((double)pageArea.getMinX()), (float)PageDesc.toPoints((double)pageArea.getMinY()), (float)PageDesc.toPoints((double)pageArea.getWidth()), (float)PageDesc.toPoints((double)pageArea.getHeight()));
            document = new Document(pageArea2);
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file, false);
            try {
                writer = PdfWriter.getInstance((Document)document, (OutputStream)fos);
            }
            catch (DocumentException e) {
                throw new IOException(e);
            }
            document.open();
            for (PrintPage page : this.pages) {
                if (document.newPage()) {
                    PdfContentByte cb = writer.getDirectContent();
                    g2 = cb.createGraphics(pageArea2.getWidth(), pageArea2.getHeight(), this.mapper);
                    Rectangle2D.Float contentArea2 = new Rectangle2D.Float(PageDesc.toPoints((double)contentArea.getMinX()), PageDesc.toPoints((double)contentArea.getMinY()), PageDesc.toPoints((double)contentArea.getWidth()), PageDesc.toPoints((double)contentArea.getHeight()));
                    page.print((Graphics2D)g2, contentArea2);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                if (g2 != null) {
                    g2.dispose();
                }
                if (document != null) {
                    document.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (g2 != null) {
                g2.dispose();
            }
            if (document != null) {
                document.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        catch (Exception exception) {}
    }

    static interface PrintPage {
        public void print(Graphics2D var1, Rectangle2D var2);
    }

    static class TrendPage
    implements PrintPage {
        boolean autoscale;
        TrendNode trend;

        TrendPage() {
        }

        public static TrendPage createFrom(TrendNode srcTrend) {
            TrendPage page = new TrendPage();
            CanvasContext ctx = TrendInitializer.createDefaultCanvas(AWTThread.getThreadAccess(), srcTrend.historian, srcTrend.collector, null, srcTrend.getTrendSpec());
            TrendNode trend = TrendInitializer.getTrendNode(ctx);
            trend.setViewport(srcTrend.getViewport());
            page.autoscale = false;
            if (srcTrend.milestones != null) {
                trend.setMilestones(srcTrend.milestones);
            }
            trend.printing = true;
            page.trend = trend;
            return page;
        }

        public static TrendPage addTrendPage(TrendSpec trendSpec, HistoryManager historian, MilestoneSpec milestones, Viewport viewport) {
            TrendPage page = new TrendPage();
            CanvasContext ctx = TrendInitializer.createDefaultCanvas(AWTThread.getThreadAccess(), historian, null, null, trendSpec);
            TrendNode trend = TrendInitializer.getTrendNode(ctx);
            trend.printing = true;
            if (milestones != null) {
                trend.setMilestones(milestones);
            }
            if (viewport != null) {
                trend.setViewport(viewport);
                page.autoscale = false;
            } else {
                page.autoscale = true;
            }
            page.trend = trend;
            return page;
        }

        @Override
        public void print(Graphics2D g2d, Rectangle2D pageArea) {
            new Rectangle2D.Float(PageDesc.toPoints((double)pageArea.getMinX()), PageDesc.toPoints((double)pageArea.getMinY()), PageDesc.toPoints((double)pageArea.getWidth()), PageDesc.toPoints((double)pageArea.getHeight()));
            java.awt.Rectangle r2 = g2d.getClipBounds();
            java.awt.Rectangle r = g2d.getClipBounds();
            r.width *= 2;
            r.height *= 2;
            g2d.scale(0.5, 0.5);
            g2d.setClip(r);
            try {
                this.trend.setSize(r.width, r.height);
                if (this.autoscale) {
                    this.trend.zoomOut();
                }
                this.trend.layout();
                this.trend.render(g2d);
            }
            finally {
                g2d.scale(2.0, 2.0);
                g2d.setClip(r2);
            }
        }
    }
}

