/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.junit.v2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.simantics.Simantics;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.testing.common.AcornTests;
import org.simantics.debug.browser.internal.Activator;
import org.simantics.tests.modelled.junit.v2.ModelledSTSSuiteRunner;
import org.simantics.tests.modelled.utils.ModelledSTSSuite;
import org.simantics.tests.modelled.utils.STSSuiteTestCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelledSTSRunner
extends ParentRunner<ModelledSTSSuiteRunner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelledSTSRunner.class);
    public static final String INCLUSION_FILTER = "org.simantics.tests.modelled.singleTestIncludeFilter";
    public static final String EXCLUSION_FILTER = "org.simantics.tests.modelled.excludeFilter";
    private final List<ModelledSTSSuiteRunner> children;

    public ModelledSTSRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        try {
            Collection filtered;
            this.initialize0();
            Collection suites = STSSuiteTestCollector.collectTests();
            String exclusionFilter = System.getProperty(EXCLUSION_FILTER);
            if (exclusionFilter != null) {
                String[] filters = exclusionFilter.split(",");
                filtered = suites.stream().filter(s -> !ModelledSTSRunner.startsWithAny(s, filters)).collect(Collectors.toList());
            } else {
                filtered = suites;
            }
            List sorted = filtered.stream().sorted((o1, o2) -> Integer.compare(o1.getPriority(), o2.getPriority())).collect(Collectors.toList());
            this.children = new ArrayList<ModelledSTSSuiteRunner>(sorted.size());
            for (ModelledSTSSuite suite : sorted) {
                this.children.add(new ModelledSTSSuiteRunner(suite));
            }
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private static boolean startsWithAny(ModelledSTSSuite suite, String[] filters) {
        String[] stringArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (suite.getName().contains(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<ModelledSTSSuiteRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ModelledSTSSuiteRunner child) {
        return child.getDescription();
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testRunFinished(Result result) throws Exception {
                ModelledSTSRunner.this.deinitialize0();
            }
        });
        super.run(notifier);
    }

    protected void runChild(ModelledSTSSuiteRunner child, RunNotifier notifier) {
        try {
            child.run(notifier);
        }
        finally {
            Layer0Utils.queryDebugSupport((String)"QueryControl.flush");
        }
    }

    public void initialize() throws InitializationError {
    }

    public void deinitialize() throws Exception {
    }

    private void initialize0() throws Exception {
        AcornTests.newSimanticsWorkspace(null, null);
        Activator.getDefault().startDebugServer();
        this.initialize();
    }

    private void deinitialize0() throws Exception {
        this.deinitialize();
        Activator.getDefault().stopDebugServer();
        Simantics.shutdown((IProgressMonitor)new NullProgressMonitor());
    }
}

