/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.commands.TestScriptExecutor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.coverage.CombinedCoverage;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptionsAdvisor;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.runtime.RuntimeModule;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestsGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestsGraphUtils.class);
    private static final String STS_TEST_PREFIX = "STSTest";
    private static final String STS_SUITE_PREFIX = "STSSuite";
    private static final String STS_VARIABLE_PREFIX = "STSVariable";

    private TestsGraphUtils() {
    }

    public static Resource createSTSVariable(WriteGraph graph, Resource parent) throws DatabaseException {
        String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)STS_VARIABLE_PREFIX, (Resource)parent);
        Resource stsVariable = graph.newResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        graph.claim(parent, L0.ConsistsOf, L0.PartOf, stsVariable);
        graph.claim(stsVariable, L0.InstanceOf, TESTS.STSVariable);
        graph.claimLiteral(stsVariable, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        graph.claimLiteral(stsVariable, TESTS.STSVariable_definition, (Object)"", (Binding)Bindings.STRING);
        return stsVariable;
    }

    public static Resource createSTSTest(WriteGraph graph, Resource parent) throws DatabaseException {
        String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)STS_TEST_PREFIX, (Resource)parent);
        Resource stsTest = graph.newResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        graph.claim(parent, L0.ConsistsOf, L0.PartOf, stsTest);
        graph.claim(stsTest, L0.InstanceOf, TESTS.STSTest);
        graph.claimLiteral(stsTest, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        graph.claimLiteral(stsTest, TESTS.STSTest_definition, (Object)"", (Binding)Bindings.STRING);
        return stsTest;
    }

    public static Resource createSTSSuite(WriteGraph graph, Resource parent) throws DatabaseException {
        String name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)STS_SUITE_PREFIX, (Resource)parent);
        Resource stsSuite = graph.newResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        graph.claim(parent, L0.ConsistsOf, L0.PartOf, stsSuite);
        graph.claim(stsSuite, L0.InstanceOf, TESTS.STSSuite);
        graph.claimLiteral(stsSuite, L0.HasName, (Object)name, (Binding)Bindings.STRING);
        return stsSuite;
    }

    public static CombinedCoverage runSTSTestDefinition(String definition, final List<Pattern> moduleNameFilters, SCLReportingHandler handler) throws IOException {
        ModuleRepository repo = new ModuleRepository(SCLOsgi.SOURCE_REPOSITORY);
        repo.setAdvisor(new ModuleCompilationOptionsAdvisor(){

            public ModuleCompilationOptions getOptions(String moduleName) {
                boolean coverage = false;
                for (Pattern p : moduleNameFilters) {
                    if (!p.matcher(moduleName.toLowerCase()).find()) continue;
                    coverage = true;
                    break;
                }
                return new ModuleCompilationOptions(coverage);
            }
        });
        CommandSession session = new CommandSession(repo, handler);
        TestScriptExecutor executor = new TestScriptExecutor(session, new BufferedReader(new StringReader(definition)), handler);
        try {
            executor.execute();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to execute test definition:\n{}", (Object)definition, (Object)t);
        }
        Collection runtimeModules = session.getRuntimeEnvironment().getRuntimeModules();
        ArrayList<Module> modules = new ArrayList<Module>(runtimeModules.size());
        for (RuntimeModule module : runtimeModules) {
            modules.add(module.getModule());
        }
        CombinedCoverage coverage = CoverageUtils.getCoverage(modules);
        return coverage;
    }

    public static byte[] stsTestContentDump(ReadGraph graph, Resource test) throws DatabaseException {
        TestsResource TESTS = TestsResource.getInstance((ReadGraph)graph);
        String def = (String)graph.getRelatedValue(test, TESTS.STSTest_definition, (Binding)Bindings.STRING);
        return def.getBytes(StandardCharsets.UTF_8);
    }
}

