/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.tests.modelled.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.tests.modelled.ontology.TestsResource;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;

public class STSSuiteSorterRule implements SorterRule, Sorter {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Sorter getSorter(ReadGraph graph, Object content) throws DatabaseException {
        return this;
    }

    @Override
    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException
    {
        try {
            STSTestComparator stc = new STSTestComparator();
            stc.graph = graph;
            Collections.sort(nodes, stc);
        } catch (RuntimeDatabaseException e) {
            if (e.getCause()!=null && e.getCause() instanceof DatabaseException) throw (DatabaseException) e.getCause();
            throw e;
        }
    }

    static class STSTestQuery extends ResourceRead<Pair<Integer, String>> {

        public STSTestQuery(Resource resource) {
            super(resource);
        }

        @Override
        public Pair<Integer, String> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance(graph);
            TestsResource TESTS = TestsResource.getInstance(graph);
            String name = graph.getRelatedValue2(resource, L0.HasName, Bindings.STRING);
            if(graph.isInstanceOf(resource, TESTS.STSTest)) {
                Integer priority = graph.getRelatedValue2(resource, TESTS.STSTest_executionPriority, Bindings.INTEGER);
                return new Pair<Integer, String>(priority, name);
            } else {
                return new Pair<Integer, String>(0, name);
            }

        }

    }

    static class STSTestComparator implements Comparator<NodeContext> {
        ReadGraph graph;

        @Override
        public int compare(NodeContext nc1, NodeContext nc2) {
            Resource r1 = (Resource) nc1.getConstant(BuiltinKeys.INPUT);
            Resource r2 = (Resource) nc2.getConstant(BuiltinKeys.INPUT);

            try {
                Pair<Integer, String> test1 = graph.sync(new STSTestQuery(r1));
                Pair<Integer, String> test2 = graph.sync(new STSTestQuery(r2));

                if (test1.first < test2.first)
                    return -1;
                else if (test1.first > test2.first)
                    return 1;
                else return AlphanumComparator.COMPARATOR.compare(test1.second, test2.second);

            } catch (DatabaseException e) {
                throw new RuntimeDatabaseException(e);
            }
        }
    }
}
