/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import java.io.File;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.team.Activator;
import org.simantics.team.ui.CommentDialog;
import org.simantics.team.ui.StageInitWizard;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;
import org.simantics.utils.ui.dialogs.ShowError;

public class StageInitHandler extends AbstractPreferenceHandler {

    public StageInitHandler() {
        super(Activator.getDefault());
    }
    private void showError(String msg, Throwable t) {
        String title = "Staging Initialization";
        ShowError.showError(title, msg, t);
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("DEBUG: " + this.getClass().getName());
        try {
            Session session = Simantics.getSession();
            File wsFolder = new File(Platform.getInstanceLocation().getURL().getFile());
            File stFolder = new File(wsFolder, "staging");
            final StageInitWizard.Data data = new StageInitWizard.Data(stFolder, null);
            if (!StageInitWizard.openInitWizard(data))
                return null; // User cancelled the operation.
            File tf = data.teamFolder;
            assert(null != tf && tf.isDirectory() && tf.list().length == 0);
            CommentDialog.Data  commentData = CommitAllHandler.commitAll(data.teamFolder, true); // init
            if (!commentData.ok)
                return null; // User cancelled the operation.
            //Utils.setTeamFolder(tf);
            SynchroniseAllHandler.pullAll(session, tf, stFolder);
            SynchroniseAllHandler.show(session, tf, stFolder);
        } catch (Throwable t) {
            showError("Failed!", t);
        }
        return null;
    }
}