/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.XSupport;
import org.simantics.team.Activator;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;

public class DebugHandler extends AbstractPreferenceHandler {
    public DebugHandler() {
        super(Activator.getDefault());
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
//        ISelection sel = HandlerUtil.getCurrentSelection(event);
//        IStructuredSelection ss = StructuredSelection.EMPTY;
//        if (sel instanceof IStructuredSelection)
//            ss = (IStructuredSelection) sel;
        try {
            Session s = Simantics.getSession();
            s.sync(new WriteRequest() {
                @Override
                public void perform(WriteGraph graph) throws DatabaseException {
                    XSupport xs = graph.getService(XSupport.class);
                    //Layer0 l0 = Layer0.getInstance(graph);
                    Resource r = graph.newResource();
                    String msg = "Corrupt cluster r=" + r; 
                    System.out.println(msg);
                    CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
                    cm.add(msg);
                    xs.corruptCluster(r);
                    Resource rr = graph.newResource();
                    msg = "Corrupt cluster rr=" + rr;
                    System.out.println(msg);
                    cm.add(msg);
                    xs.corruptCluster(rr);
                    graph.addMetadata(cm); // Add comment to change set.
                    //graph.claim(l0.InstanceOf, l0.Inherits, l0.Entity);
                }
            });
        } catch (DatabaseException e) {
            e.printStackTrace();
        }  finally {
        }
        return null;
    }
}
