/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.queries;

import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.CollectionSupport;
import org.simantics.structural.stubs.StructuralResource2;

public class ConnectionSet {
    final Set<Resource> connections;
    THashSet<Resource> joins;
    THashSet<Resource> excluded;
    THashSet<Resource> excludedJoins;
    StructuralResource2 sr;

    public ConnectionSet(ReadGraph graph) {
        this.sr = StructuralResource2.getInstance((ReadGraph)graph);
        this.connections = ((CollectionSupport)graph.getService(CollectionSupport.class)).createSet();
    }

    public boolean excludeConnection(Resource connection) {
        if (this.excluded == null) {
            this.excluded = new THashSet();
        }
        return this.excluded.add((Object)connection);
    }

    public boolean excludeJoin(Resource join) {
        if (this.excludedJoins == null) {
            this.excludedJoins = new THashSet();
        }
        return this.excludedJoins.add((Object)join);
    }

    public boolean excludeConnections(Collection<Resource> connections) {
        if (connections.isEmpty()) {
            return false;
        }
        if (this.excluded == null) {
            this.excluded = new THashSet();
        }
        return this.excluded.addAll(connections);
    }

    public boolean isExcluded(Resource connection) {
        return this.excluded != null && this.excluded.contains((Object)connection);
    }

    public boolean isJoinExcluded(Resource join) {
        return this.excludedJoins != null && this.excludedJoins.contains((Object)join);
    }

    public void addConnection(ReadGraph g, Resource connection) throws DatabaseException {
        if (this.isExcluded(connection)) {
            return;
        }
        if (this.connections.add(connection)) {
            if (this.sr == null) {
                this.sr = StructuralResource2.getInstance((ReadGraph)g);
            }
            for (Resource join : g.getObjects(connection, this.sr.IsJoinedBy)) {
                this.addJoin(g, join);
            }
        }
    }

    public void addJoin(ReadGraph g, Resource join) throws DatabaseException {
        if (this.isJoinExcluded(join)) {
            return;
        }
        if (this.joins == null) {
            this.joins = new THashSet();
        }
        if (this.joins.add((Object)join)) {
            if (this.sr == null) {
                this.sr = StructuralResource2.getInstance((ReadGraph)g);
            }
            for (Resource connection : g.getObjects(join, this.sr.Joins)) {
                this.addConnection(g, connection);
            }
        }
    }

    public Set<Resource> getConnections() {
        return this.connections;
    }

    public Set<Resource> getJoins() {
        if (this.joins == null) {
            return Collections.emptySet();
        }
        return this.joins;
    }
}

