/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.Functions;

public class DefinedUCInterfaceMap
extends ResourceRead<Collection<Functions.InterfaceResolution>> {
    public DefinedUCInterfaceMap(Resource resource) {
        super(resource);
    }

    public Collection<Functions.InterfaceResolution> perform(ReadGraph graph) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource definition = graph.getPossibleObject(this.resource, STR.IsDefinedBy);
        if (definition != null) {
            ArrayList<Functions.InterfaceResolution> result = new ArrayList<Functions.InterfaceResolution>();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource cp : (Collection)graph.syncRequest((Read)new ObjectsWithType(this.resource, L0.ConsistsOf, STR.ConnectionRelation))) {
                String cpName = (String)graph.getRelatedValue(cp, L0.HasName, (Binding)Bindings.STRING);
                for (Resource conn : graph.getObjects(cp, STR.IsBoundBy)) {
                    Statement stm = graph.getPossibleStatement(conn, STR.Connects);
                    if (stm == null) continue;
                    Resource component = stm.getObject();
                    String componentName = (String)graph.getRelatedValue(component, L0.HasName, (Binding)Bindings.STRING);
                    result.add(new Functions.InterfaceResolution(cp, cpName, componentName, graph.getInverse(stm.getPredicate())));
                }
            }
            return result;
        }
        return null;
    }
}

