/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural2.modelingRules;

import java.util.Collection;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class SimpleModelingRules extends AbstractModelingRules {

	private Resource connectionType;	
	private Resource attachmentRelation;
	
	public SimpleModelingRules(Resource connectionType, Resource attachmentRelation) {
		this.connectionType = connectionType;
		this.attachmentRelation = attachmentRelation;
	}

	IAttachmentRelationMap attachmentRelations = new IAttachmentRelationMap() {		
		@Override
		public Resource get(ReadGraph g, CPTerminal cp) throws DatabaseException {
			return attachmentRelation;
		}
	};
	
	@Override
	public ConnectionJudgement judgeConnection(ReadGraph g,
			Collection<IConnectionPoint> connectionPoints)
			throws DatabaseException {
		ConnectionJudgement judgement = new ConnectionJudgement(connectionType);
		judgement.attachmentRelations = attachmentRelations;
		return judgement;
	}

	@Override
	public Resource computeConnectionType(ReadGraph g, Collection<IConnectionPoint> connectionPoints)
			throws DatabaseException {
		return connectionType;
	}
	
	@Override
	public IAttachmentRelationMap getAttachmentRelations(ReadGraph g,
			Resource connection) {
		return attachmentRelations;
	}

	@Override
	public Set<CPTerminal> resolveTerminals(ReadGraph g,
			Collection<IConnectionPoint> connectionPoints)
			throws DatabaseException {
		throw new UnsupportedOperationException("Simple Modelling Rules do not process actual connection points");
	}

}
