/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.Map;

import org.simantics.browsing.ui.graph.contributor.labeler.ColumnLabelerContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.modelBrowser.nodes.RunNode;

/**
 * @author Tuukka Lehtonen
 */
public class RunLabeler extends ColumnLabelerContributor<RunNode> {

    @Override
    public Map<String, String> getLabel(ReadGraph graph, RunNode node) throws DatabaseException {
        return RunLabelRule.INSTANCE.getLabel(graph, node.resource);
    }

}
