/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.structural.ui.modelBrowser.contributions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.ArrayMap;

/**
 * @author Tuukka Lehtonen
 */
public enum RunLabelRule implements LabelRule {

    INSTANCE;

	static final SimpleDateFormat HHmmss = new SimpleDateFormat("HH:mm:ss");
	
    public static RunLabelRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Resource run = (Resource) content;

        Layer0 L0 = Layer0.getInstance(graph);
        String label = graph.getPossibleRelatedValue2(run, L0.HasLabel);
        if (label == null)
            return ArrayMap.make(ColumnKeys.KEYS_SINGLE, new String[] { "" });
        
        SimulationResource SIMU = SimulationResource.getInstance(graph);
        // FIXME: small database backwards compatibility hack
        if (SIMU.HasActivationTime != null) {
            Long activationTime = graph.getPossibleRelatedValue(run, SIMU.HasActivationTime, Bindings.LONG);
            if (activationTime != null) {
                String time = HHmmss.format(new Date(activationTime));
                label += " ("+time+")";
            }
        }

        return ArrayMap.make(ColumnKeys.KEYS_SINGLE, new String[] { label });
    }

}
