/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementatio
 *******************************************************************************/
package org.simantics.structural.ui.menuContributions;

import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.ShowMaxChildrenProcessor;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.structural.ui.Activator;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ShowAllChildrenContribution extends CompoundContributionItem {

    static IContributionItem[] NONE = {};

    @Override
    protected IContributionItem[] getContributionItems() {
        IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
        if (part == null)
            return NONE;

        GraphExplorer explorer = (GraphExplorer) part.getAdapter(GraphExplorer.class);
        if (explorer == null)
            return NONE;

        ISelectionProvider sp = (ISelectionProvider) explorer.getAdapter(ISelectionProvider.class);
        if (sp == null)
            return NONE;

        ISelection s = sp.getSelection();
        List<NodeContext> nodes = ISelectionUtils.getPossibleKeys(s, SelectionHints.KEY_MAIN, NodeContext.class);
        if (nodes.isEmpty())
            return NONE;

        boolean allTruncated = true;
        for (NodeContext node : nodes) {
            PrunedChildrenResult prunedChildren = explorer.query(node, BuiltinKeys.PRUNED_CHILDREN);
            NodeContext[] finalChildren = explorer.query(node, BuiltinKeys.FINAL_CHILDREN);
            if (prunedChildren == null || finalChildren == null
                    || prunedChildren.getPrunedChildren().length == finalChildren.length) {
                allTruncated = false;
                break;
            }
        }
        if (!allTruncated)
            return NONE;

        ShowMaxChildrenProcessor processor = (ShowMaxChildrenProcessor) explorer.getPrimitiveProcessor(BuiltinKeys.SHOW_MAX_CHILDREN);
        if (processor == null)
            return NONE;

        // Show all children
        return new IContributionItem[] {
                new ActionContributionItem(new ShowAllChildrenAction(processor, nodes))
        };
    }

    static class ShowAllChildrenAction extends Action {
        private ShowMaxChildrenProcessor processor;
        private List<NodeContext>        nodes;

        public ShowAllChildrenAction(ShowMaxChildrenProcessor processor, List<NodeContext> nodes) {
            super("Show All Children");
            setImageDescriptor(Activator.SHOW_ALL_CHILDREN_ICON);
            this.processor = processor;
            this.nodes = nodes;
        }

        @Override
        public void run() {
            for (NodeContext node : nodes)
                processor.replaceShowMaxChildren(node, Integer.MAX_VALUE);
        }
    }

}
