package org.simantics.structural.ui.menuContributions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/**
 * Clients may extend, but must remember to invoke
 * @author Tuukka Lehtonen
 */
public class PreferenceCheckBoxAction extends Action implements IPropertyChangeListener {

    protected String preferenceKey;
    protected IPreferenceStore preferenceStore;

    /**
     * Constructs an action to toggle console auto activation preferences
     * @param preferenceKey 
     */
    public PreferenceCheckBoxAction(String name, String preferenceKey, IPreferenceStore preferenceStore) {
        super(name, IAction.AS_CHECK_BOX);
        this.preferenceKey = preferenceKey;
        this.preferenceStore = preferenceStore;
        setToolTipText(name);
        getPreferenceStore().addPropertyChangeListener(this);
        update();
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(getKey())) {
            update();
        }
    }

    protected String getKey() {
        return preferenceKey;
    }

    private void update() {
        IPreferenceStore store = getPreferenceStore();
        if (store.getBoolean(getKey())) {
            // on
            setChecked(true);
        } else {
            // off
            setChecked(false);
        }
    }

    /**
     * @return
     */
    protected IPreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.action.Action#run()
     */
    @Override
    public void run() {
        IPreferenceStore store = getPreferenceStore();
        boolean show = isChecked();
        store.removePropertyChangeListener(this);
        store.setValue(getKey(), show);
        store.addPropertyChangeListener(this);
    }

    /**
     * Must be called to dispose this action.
     */
    public void dispose() {
        getPreferenceStore().removePropertyChangeListener(this);
    }

}
